/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.Animation;
import com.teragard.CacheArchive;
import com.teragard.MemCache;
import com.teragard.Model;
import com.teragard.Stream;

public final class SpotAnim {
    public int anInt400 = 9;
    public static SpotAnim[] cache;
    private int id;
    private int modelId;
    private int animationId = -1;
    public Animation animation;
    private final int[] originalColours = new int[6];
    private final int[] destColours = new int[6];
    public int sizeXY = 128;
    public int sizeZ = 128;
    public int rotation;
    public int shadow;
    public int lightness;
    public static MemCache modelCache;

    public static void unpackConfig(CacheArchive streamLoader) {
        Stream stream = new Stream(streamLoader.getDataForName("spotanim.dat"));
        int length = stream.readUnsignedWord();
        if (cache == null) {
            cache = new SpotAnim[length];
        }
        for (int j = 0; j < length; ++j) {
            if (cache[j] == null) {
                SpotAnim.cache[j] = new SpotAnim();
            }
            SpotAnim.cache[j].id = j;
            cache[j].readValues(stream);
        }
        SpotAnim.custom();
    }

    private static void custom() {
        SpotAnim.cache[2274].modelId = SpotAnim.cache[2281].modelId;
        SpotAnim.cache[2274].animationId = SpotAnim.cache[2281].animationId;
        SpotAnim.cache[2274].rotation = 90;
        SpotAnim.cache[2274].animation = SpotAnim.cache[2281].animation;
    }

    private void readValues(Stream stream) {
        int i;
        block0: while ((i = stream.readUnsignedByte()) != 0) {
            if (i == 1) {
                this.modelId = stream.readUnsignedWord();
                continue;
            }
            if (i == 2) {
                this.animationId = stream.readUnsignedWord();
                if (Animation.anims == null) continue;
                this.animation = Animation.anims[this.animationId];
                continue;
            }
            if (i == 4) {
                this.sizeXY = stream.readUnsignedWord();
                continue;
            }
            if (i == 5) {
                this.sizeZ = stream.readUnsignedWord();
                continue;
            }
            if (i == 6) {
                this.rotation = stream.readUnsignedWord();
                continue;
            }
            if (i == 7) {
                this.shadow = stream.readUnsignedByte();
                continue;
            }
            if (i == 8) {
                this.lightness = stream.readUnsignedByte();
                continue;
            }
            if (i == 40) {
                int j = stream.readUnsignedByte();
                int k = 0;
                while (true) {
                    if (k >= j) continue block0;
                    this.originalColours[k] = stream.readUnsignedWord();
                    this.destColours[k] = stream.readUnsignedWord();
                    ++k;
                }
            }
            System.out.println("Error unrecognised spotanim config code: " + i);
        }
        return;
    }

    public Model getModel() {
        Model model = (Model)modelCache.get(this.id);
        if (model != null) {
            return model;
        }
        model = Model.fetchModel(this.modelId);
        if (model == null) {
            return null;
        }
        for (int i = 0; i < 6; ++i) {
            if (this.originalColours[0] == 0) continue;
            model.recolour(this.originalColours[i], this.destColours[i]);
        }
        modelCache.put(model, this.id);
        return model;
    }

    private SpotAnim() {
    }

    static {
        modelCache = new MemCache(30);
    }
}

