/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.Background;
import com.teragard.CacheArchive;
import com.teragard.Client;
import com.teragard.DrawingArea;
import com.teragard.Stream;
import com.teragard.signlink;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class Sprite
extends DrawingArea {
    public int movingX;
    public int movingY = 0;
    public boolean movedEnough = false;
    private boolean startedMoving = false;
    public int[] myPixels;
    public int myWidth;
    public int myHeight;
    public int drawOffsetX;
    public int drawOffsetY;
    public int maxWidth;
    public int maxHeight;
    public String sourceRef;

    public void setAlphaTransparency(int a) {
        for (int pixel = 0; pixel < this.myPixels.length; ++pixel) {
            if ((this.myPixels[pixel] >> 24 & 0xFF) != a) continue;
            this.myPixels[pixel] = 0;
        }
    }

    public static Image scale(Image image, int width, int height) {
        return image.getScaledInstance(width, height, 1);
    }

    public static BufferedImage getScaledImage(Image loadingSprites, int w, int h, int origW, int origH) {
        BufferedImage resizedImage = new BufferedImage(w, h, 2);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(loadingSprites, 0, 0, origW, origH, null);
        g.dispose();
        return resizedImage;
    }

    public Sprite(String var1, int dummy) {
        try {
            Image var2 = Toolkit.getDefaultToolkit().getImage(signlink.findcachedir() + "Sprites/" + var1 + ".png");
            ImageIcon var3 = new ImageIcon(var2);
            this.myWidth = var3.getIconWidth();
            this.maxHeight = this.myHeight = var3.getIconHeight();
            this.drawOffsetX = 0;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber var6 = new PixelGrabber(var2, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            var6.grabPixels();
            var2 = null;
        }
        catch (Exception var5) {
            System.out.println(var5);
        }
    }

    public Sprite(URL url) {
        try {
            if (url == null) {
                return;
            }
            HttpURLConnection httpcon = (HttpURLConnection)url.openConnection();
            httpcon.addRequestProperty("User-Agent", "Mozilla/4.76");
            BufferedImage image = ImageIO.read(httpcon.getInputStream());
            this.myWidth = image.getWidth();
            this.myHeight = image.getHeight();
            this.maxWidth = this.myWidth;
            this.maxHeight = this.myHeight;
            this.drawOffsetX = 0;
            this.drawOffsetY = 0;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            pixelgrabber.grabPixels();
            Object var3_4 = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Sprite(String string, int clientWidth, int clientHeight, boolean yas) {
        try {
            Image image = Client.resourceLoader.getImage(string);
            if (image == null) {
                return;
            }
            Image resize = Sprite.scale(image, clientWidth, clientHeight);
            ImageIcon sprite = new ImageIcon(resize);
            this.myWidth = sprite.getIconWidth();
            this.myHeight = sprite.getIconHeight();
            this.maxWidth = this.myWidth;
            this.maxHeight = this.myHeight;
            this.drawOffsetX = 0;
            this.drawOffsetY = 0;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(resize, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            pixelgrabber.grabPixels();
            image = null;
            resize = null;
            this.setTransparency(255, 0, 255);
        }
        catch (Exception _ex) {
            _ex.printStackTrace();
        }
    }

    public static Image downScaleImage(Image image, int width, int height) {
        return image.getScaledInstance(width, height, 4);
    }

    public static Image getImageFromArray(int[] pixels, int width, int height) {
        MemoryImageSource mis = new MemoryImageSource(width, height, pixels, 0, width);
        Toolkit tk = Toolkit.getDefaultToolkit();
        return tk.createImage(mis);
    }

    public static Sprite getCutted(Sprite s, int width, int height) {
        try {
            Sprite sprite = new Sprite();
            Image image = Sprite.getImageFromArray(s.myPixels, s.myWidth, s.myHeight);
            sprite.myWidth = width;
            sprite.myHeight = height;
            sprite.maxWidth = sprite.myWidth;
            sprite.maxHeight = sprite.myHeight;
            sprite.drawOffsetX = 0;
            sprite.drawOffsetY = 0;
            sprite.myPixels = new int[sprite.myWidth * sprite.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, sprite.myWidth, sprite.myHeight, sprite.myPixels, 0, sprite.myWidth);
            pixelgrabber.grabPixels();
            image = null;
            return sprite;
        }
        catch (Exception _ex) {
            _ex.printStackTrace();
            return null;
        }
    }

    public static Sprite getResizedSprite(Sprite spriteParam, int width, int height) {
        if (width == 0) {
            width = 1;
        }
        if (height == 0) {
            height = 1;
        }
        Image img = Sprite.getImageFromArray(spriteParam.myPixels, spriteParam.myWidth, spriteParam.myHeight);
        Image img_2 = Sprite.downScaleImage(img, width, height);
        ImageIcon sprite = new ImageIcon(img_2);
        Sprite toReturn = new Sprite();
        toReturn.myWidth = sprite.getIconWidth();
        toReturn.myHeight = sprite.getIconHeight();
        toReturn.maxWidth = toReturn.myWidth;
        toReturn.maxHeight = toReturn.myHeight;
        toReturn.drawOffsetX = 0;
        toReturn.drawOffsetY = 0;
        toReturn.myPixels = new int[toReturn.myWidth * toReturn.myHeight];
        PixelGrabber pixelgrabber = new PixelGrabber(img_2, 0, 0, toReturn.myWidth, toReturn.myHeight, toReturn.myPixels, 0, toReturn.myWidth);
        try {
            pixelgrabber.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        img_2 = null;
        img = null;
        toReturn.setTransparency(255, 0, 255);
        toReturn.setTransparency(255, 255, 255);
        return toReturn;
    }

    public Sprite(int i, int j) {
        this.myPixels = new int[i * j];
        this.myWidth = this.maxWidth = i;
        this.myHeight = this.maxHeight = j;
        this.drawOffsetY = 0;
        this.drawOffsetX = 0;
    }

    public Sprite(byte[] spriteData) {
        try {
            Image image = Toolkit.getDefaultToolkit().createImage(spriteData);
            ImageIcon sprite = new ImageIcon(image);
            this.myWidth = sprite.getIconWidth();
            this.myHeight = sprite.getIconHeight();
            this.maxWidth = this.myWidth;
            this.maxHeight = this.myHeight;
            this.drawOffsetX = 0;
            this.drawOffsetY = 0;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            pixelgrabber.grabPixels();
            image = null;
            this.setTransparency(255, 0, 255);
            this.setTransparency(255, 255, 255);
        }
        catch (Exception _ex) {
            _ex.printStackTrace();
        }
    }

    public void drawMovingSprite(int finalCoordX, int finalCoordY, int startingX, int startingY, int speed, char coordToMove, boolean advancedSprite) {
        if (!this.startedMoving) {
            this.movingX = startingX;
            this.movingY = startingY;
            this.startedMoving = true;
        }
        if (!this.movedEnough) {
            if (coordToMove == 'y') {
                this.movingY += speed;
            }
            if (coordToMove == 'x') {
                this.movingX += speed;
            }
            if (coordToMove == 'b') {
                this.movingX += speed;
                this.movingY += speed;
            }
            if ((speed < 0 ? this.movingX <= finalCoordX : this.movingX >= finalCoordX) && (coordToMove == 'x' || coordToMove == 'b')) {
                this.movingX = finalCoordX;
                this.movedEnough = true;
            }
            if ((speed < 0 ? this.movingY <= finalCoordY : this.movingY >= finalCoordY) && (coordToMove == 'y' || coordToMove == 'b')) {
                this.movingY = finalCoordY;
                this.movedEnough = true;
            }
            this.setSprite(coordToMove == 'y' ? startingX : this.movingX, coordToMove == 'x' ? startingY : this.movingY, advancedSprite);
        } else {
            this.setSprite(coordToMove == 'y' ? startingX : this.movingX, coordToMove == 'x' ? startingY : this.movingY, advancedSprite);
        }
    }

    public void setSprite(int spriteX, int spriteY, boolean advancedSprite) {
        if (advancedSprite) {
            this.drawAdvancedSprite(spriteX, spriteY);
        } else {
            this.drawSprite(spriteX, spriteY);
        }
    }

    public void drawSprite1(int i, int j, int k) {
        int i1 = (i += this.drawOffsetX) + (j += this.drawOffsetY) * DrawingArea.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = DrawingArea.width - l1;
        int j2 = 0;
        if (j < DrawingArea.topY) {
            int k2 = DrawingArea.topY - j;
            k1 -= k2;
            j = DrawingArea.topY;
            j1 += k2 * l1;
            i1 += k2 * DrawingArea.width;
        }
        if (j + k1 > DrawingArea.bottomY) {
            k1 -= j + k1 - DrawingArea.bottomY;
        }
        if (i < DrawingArea.topX) {
            int l2 = DrawingArea.topX - i;
            l1 -= l2;
            i = DrawingArea.topX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > DrawingArea.bottomX) {
            int i3 = i + l1 - DrawingArea.bottomX;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.block_copy_alpha(j1, l1, DrawingArea.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    public void drawAdvancedSprite(int i, int j, int alpha) {
        int k = alpha;
        int i1 = (i += this.drawOffsetX) + (j += this.drawOffsetY) * DrawingArea.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = DrawingArea.width - l1;
        int j2 = 0;
        if (j < DrawingArea.topY) {
            int k2 = DrawingArea.topY - j;
            k1 -= k2;
            j = DrawingArea.topY;
            j1 += k2 * l1;
            i1 += k2 * DrawingArea.width;
        }
        if (j + k1 > DrawingArea.bottomY) {
            k1 -= j + k1 - DrawingArea.bottomY;
        }
        if (i < DrawingArea.topX) {
            int l2 = DrawingArea.topX - i;
            l1 -= l2;
            i = DrawingArea.topX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > DrawingArea.bottomX) {
            int i3 = i + l1 - DrawingArea.bottomX;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.drawAlphaGlow(j1, l1, DrawingArea.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    public void drawAdvancedSprite2(int i, int j, int alpha) {
        int k = alpha;
        int i1 = (i += this.myHeight) + (j += this.myWidth) * DrawingArea.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = DrawingArea.width - l1;
        int j2 = 0;
        if (j < DrawingArea.topY) {
            int k2 = DrawingArea.topY - j;
            k1 -= k2;
            j = DrawingArea.topY;
            j1 += k2 * l1;
            i1 += k2 * DrawingArea.width;
        }
        if (j + k1 > DrawingArea.bottomY) {
            k1 -= j + k1 - DrawingArea.bottomY;
        }
        if (i < DrawingArea.topX) {
            int l2 = DrawingArea.topX - i;
            l1 -= l2;
            i = DrawingArea.topX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > DrawingArea.bottomX) {
            int i3 = i + l1 - DrawingArea.bottomX;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.drawAlphaGlow(j1, l1, DrawingArea.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    private void drawAlphaGlow(int i, int j, int[] ai, int[] ai1, int l, int i1, int j1, int k1, int l1) {
        int op = k1;
        for (int k2 = -i1; k2 < 0; ++k2) {
            for (int l2 = -j; l2 < 0; ++l2) {
                int k;
                k1 = this.myPixels[i] >> 26 & op;
                int j2 = 256 - k1;
                if ((k = ai1[i++]) != 0) {
                    int i3 = ai[l1];
                    ai[l1++] = ((k & 0xFF00FF) * k1 + (i3 & 0xFF00FF) * j2 & 0xFF00FF00) + ((k & 0xFF00) * k1 + (i3 & 0xFF00) * j2 & 0xFF0000) >> 8;
                    continue;
                }
                ++l1;
            }
            l1 += j1;
            i += l;
        }
    }

    public void drawAdvancedSprite(int i, int j) {
        int k = 256;
        int i1 = i + j * DrawingArea.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = DrawingArea.width - l1;
        int j2 = 0;
        if (j < DrawingArea.topY) {
            int k2 = DrawingArea.topY - j;
            k1 -= k2;
            j = DrawingArea.topY;
            j1 += k2 * l1;
            i1 += k2 * DrawingArea.width;
        }
        if (j + k1 > DrawingArea.bottomY) {
            k1 -= j + k1 - DrawingArea.bottomY;
        }
        if (i < DrawingArea.topX) {
            int l2 = DrawingArea.topX - i;
            l1 -= l2;
            i = DrawingArea.topX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > DrawingArea.bottomX) {
            int i3 = i + l1 - DrawingArea.bottomX;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.drawAlphaSprite(j1, l1, DrawingArea.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    public void drawCenteredARGBImage(int x, int y) {
        this.drawARGBImage(x - this.myWidth / 2, y - this.myHeight / 2);
    }

    public void drawARGBImage(int xPos, int yPos) {
        this.drawARGBSprite(xPos, yPos, 256);
    }

    public void drawARGBSprite(int xPos, int yPos, int alpha) {
        int alphaValue = alpha;
        int i1 = (xPos += this.drawOffsetX) + (yPos += this.drawOffsetY) * DrawingArea.width;
        int j1 = 0;
        int spriteHeight = this.myHeight;
        int spriteWidth = this.myWidth;
        int i2 = DrawingArea.width - spriteWidth;
        int j2 = 0;
        if (yPos < DrawingArea.topY) {
            int k2 = DrawingArea.topY - yPos;
            spriteHeight -= k2;
            yPos = DrawingArea.topY;
            j1 += k2 * spriteWidth;
            i1 += k2 * DrawingArea.width;
        }
        if (yPos + spriteHeight > DrawingArea.bottomY) {
            spriteHeight -= yPos + spriteHeight - DrawingArea.bottomY;
        }
        if (xPos < DrawingArea.topX) {
            int l2 = DrawingArea.topX - xPos;
            spriteWidth -= l2;
            xPos = DrawingArea.topX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (xPos + spriteWidth > DrawingArea.bottomX) {
            int i3 = xPos + spriteWidth - DrawingArea.bottomX;
            spriteWidth -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (spriteWidth > 0 && spriteHeight > 0) {
            this.renderARGBPixels(spriteWidth, spriteHeight, this.myPixels, DrawingArea.pixels, i1, alphaValue, j1, j2, i2);
        }
    }

    private void renderARGBPixels(int spriteWidth, int spriteHeight, int[] spritePixels, int[] renderAreaPixels, int pixel, int alphaValue, int i, int l, int j1) {
        for (int height = -spriteHeight; height < 0; ++height) {
            for (int width = -spriteWidth; width < 0; ++width) {
                int pixelLevel;
                alphaValue = this.myPixels[i] >> 24 & 0xFF;
                int alphaLevel = 256 - alphaValue;
                if ((pixelLevel = spritePixels[i++]) != 0) {
                    int pixelValue = renderAreaPixels[pixel];
                    renderAreaPixels[pixel++] = ((pixelLevel & 0xFF00FF) * alphaValue + (pixelValue & 0xFF00FF) * alphaLevel & 0xFF00FF00) + ((pixelLevel & 0xFF00) * alphaValue + (pixelValue & 0xFF00) * alphaLevel & 0xFF0000) >> 8;
                    continue;
                }
                ++pixel;
            }
            pixel += j1;
            i += l;
        }
    }

    private void drawAlphaSprite(int i, int j, int[] ai, int[] ai1, int l, int i1, int j1, int k1, int l1) {
        for (int k2 = -i1; k2 < 0; ++k2) {
            for (int l2 = -j; l2 < 0; ++l2) {
                int k;
                k1 = this.myPixels[i] >> 24 & 0xFF;
                int j2 = 256 - k1;
                if ((k = ai1[i++]) != 0) {
                    int i3 = ai[l1];
                    ai[l1++] = ((k & 0xFF00FF) * k1 + (i3 & 0xFF00FF) * j2 & 0xFF00FF00) + ((k & 0xFF00) * k1 + (i3 & 0xFF00) * j2 & 0xFF0000) >> 8;
                    continue;
                }
                ++l1;
            }
            l1 += j1;
            i += l;
        }
    }

    public Sprite(Image image) {
        try {
            ImageIcon sprite = new ImageIcon(image);
            this.myWidth = sprite.getIconWidth();
            this.myHeight = sprite.getIconHeight();
            this.maxWidth = this.myWidth;
            this.maxHeight = this.myHeight;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            pixelgrabber.grabPixels();
            image = null;
            this.setTransparency(255, 0, 255);
        }
        catch (Exception _ex) {
            _ex.printStackTrace();
        }
    }

    public Sprite(String img, int width, int height) {
        try {
            Image image;
            try {
                image = Client.resourceLoader.getImage(img);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            if (image == null) {
                return;
            }
            this.myWidth = width;
            this.myHeight = height;
            this.maxWidth = this.myWidth;
            this.maxHeight = this.myHeight;
            this.drawOffsetX = 0;
            this.drawOffsetY = 0;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            pixelgrabber.grabPixels();
            image = null;
        }
        catch (Exception _ex) {
            _ex.printStackTrace();
        }
    }

    public Sprite(Image image, int width, int height) {
        try {
            if (image == null) {
                return;
            }
            this.myWidth = width;
            this.myHeight = height;
            this.maxWidth = this.myWidth;
            this.maxHeight = this.myHeight;
            this.drawOffsetX = 0;
            this.drawOffsetY = 0;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            pixelgrabber.grabPixels();
            image = null;
        }
        catch (Exception _ex) {
            _ex.printStackTrace();
        }
    }

    public Sprite(String img) {
        try {
            Image image = Client.resourceLoader.getImage(img);
            if (image == null) {
                return;
            }
            ImageIcon sprite = new ImageIcon(image);
            this.myWidth = sprite.getIconWidth();
            this.myHeight = sprite.getIconHeight();
            this.maxWidth = this.myWidth;
            this.maxHeight = this.myHeight;
            this.drawOffsetX = 0;
            this.drawOffsetY = 0;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            pixelgrabber.grabPixels();
            image = null;
            this.setTransparency(255, 0, 255);
            if (img.contains("Crowns")) {
                this.setTransparency(255, 255, 255);
            }
        }
        catch (Exception _ex) {
            _ex.printStackTrace();
        }
    }

    public void setTransparency(int transRed, int transGreen, int transBlue) {
        for (int index = 0; index < this.myPixels.length; ++index) {
            if ((this.myPixels[index] >> 16 & 0xFF) != transRed || (this.myPixels[index] >> 8 & 0xFF) != transGreen || (this.myPixels[index] & 0xFF) != transBlue) continue;
            this.myPixels[index] = 0;
        }
    }

    public Sprite(CacheArchive streamLoader, String s, int i) {
        Stream stream = new Stream(streamLoader.getDataForName(s + ".dat"));
        Stream stream_1 = new Stream(streamLoader.getDataForName("index.dat"));
        stream_1.currentOffset = stream.readUnsignedWord();
        this.maxWidth = stream_1.readUnsignedWord();
        this.maxHeight = stream_1.readUnsignedWord();
        int j = stream_1.readUnsignedByte();
        int[] ai = new int[j];
        for (int k = 0; k < j - 1; ++k) {
            ai[k + 1] = stream_1.read3Bytes();
            if (ai[k + 1] != 0) continue;
            ai[k + 1] = 1;
        }
        for (int l = 0; l < i; ++l) {
            stream_1.currentOffset += 2;
            stream.currentOffset += stream_1.readUnsignedWord() * stream_1.readUnsignedWord();
            ++stream_1.currentOffset;
        }
        this.drawOffsetX = stream_1.readUnsignedByte();
        this.drawOffsetY = stream_1.readUnsignedByte();
        this.myWidth = stream_1.readUnsignedWord();
        this.myHeight = stream_1.readUnsignedWord();
        int i1 = stream_1.readUnsignedByte();
        int j1 = this.myWidth * this.myHeight;
        this.myPixels = new int[j1];
        if (i1 == 0) {
            for (int k1 = 0; k1 < j1; ++k1) {
                this.myPixels[k1] = ai[stream.readUnsignedByte()];
            }
            if (s.equals("mod_icons") && (i == 7 || i == 8 || i == 9)) {
                this.setTransparency(255, 255, 255);
            } else {
                this.setTransparency(255, 0, 255);
            }
            return;
        }
        if (i1 == 1) {
            for (int l1 = 0; l1 < this.myWidth; ++l1) {
                for (int i2 = 0; i2 < this.myHeight; ++i2) {
                    this.myPixels[l1 + i2 * this.myWidth] = ai[stream.readUnsignedByte()];
                }
            }
        }
        if (s.equals("mod_icons") && (i == 7 || i == 8 || i == 9)) {
            this.setTransparency(255, 255, 255);
        } else {
            this.setTransparency(255, 0, 255);
        }
    }

    public void method343() {
        DrawingArea.initDrawingArea(this.myHeight, this.myWidth, this.myPixels);
    }

    public void decodePalette(int i, int j, int k) {
        this.autoUpdate();
        for (int i1 = 0; i1 < this.myPixels.length; ++i1) {
            int j1 = this.myPixels[i1];
            if (j1 == 0) continue;
            int k1 = j1 >> 16 & 0xFF;
            if ((k1 += i) < 1) {
                k1 = 1;
            } else if (k1 > 255) {
                k1 = 255;
            }
            int l1 = j1 >> 8 & 0xFF;
            if ((l1 += j) < 1) {
                l1 = 1;
            } else if (l1 > 255) {
                l1 = 255;
            }
            int i2 = j1 & 0xFF;
            if ((i2 += k) < 1) {
                i2 = 1;
            } else if (i2 > 255) {
                i2 = 255;
            }
            this.myPixels[i1] = (k1 << 16) + (l1 << 8) + i2;
        }
    }

    public void method345() {
        this.autoUpdate();
        int[] ai = new int[this.maxWidth * this.maxHeight];
        for (int j = 0; j < this.myHeight; ++j) {
            System.arraycopy(this.myPixels, j * this.myWidth, ai, j + this.drawOffsetY * this.maxWidth + this.drawOffsetX, this.myWidth);
        }
        this.myPixels = ai;
        this.myWidth = this.maxWidth;
        this.myHeight = this.maxHeight;
        this.drawOffsetX = 0;
        this.drawOffsetY = 0;
    }

    public void method346(int i, int j) {
        this.autoUpdate();
        int l = (i += this.drawOffsetX) + (j += this.drawOffsetY) * DrawingArea.width;
        int i1 = 0;
        int j1 = this.myHeight;
        int k1 = this.myWidth;
        int l1 = DrawingArea.width - k1;
        int i2 = 0;
        if (j < DrawingArea.topY) {
            int j2 = DrawingArea.topY - j;
            j1 -= j2;
            j = DrawingArea.topY;
            i1 += j2 * k1;
            l += j2 * DrawingArea.width;
        }
        if (j + j1 > DrawingArea.bottomY) {
            j1 -= j + j1 - DrawingArea.bottomY;
        }
        if (i < DrawingArea.topX) {
            int k2 = DrawingArea.topX - i;
            k1 -= k2;
            i = DrawingArea.topX;
            i1 += k2;
            l += k2;
            i2 += k2;
            l1 += k2;
        }
        if (i + k1 > DrawingArea.bottomX) {
            int l2 = i + k1 - DrawingArea.bottomX;
            k1 -= l2;
            i2 += l2;
            l1 += l2;
        }
        if (k1 > 0 && j1 > 0) {
            this.block_copy(l, k1, j1, i2, i1, l1, this.myPixels, DrawingArea.pixels);
        }
    }

    public void block_copy(int i, int j, int k, int l, int i1, int k1, int[] ai, int[] ai1) {
        int l1 = -(j >> 2);
        j = -(j & 3);
        for (int i2 = -k; i2 < 0; ++i2) {
            for (int j2 = l1; j2 < 0; ++j2) {
                ai1[i++] = ai[i1++];
                ai1[i++] = ai[i1++];
                ai1[i++] = ai[i1++];
                ai1[i++] = ai[i1++];
            }
            for (int k2 = j; k2 < 0; ++k2) {
                ai1[i++] = ai[i1++];
            }
            i += k1;
            i1 += l;
        }
    }

    public void drawSprite1(int i, int j) {
        this.autoUpdate();
        int k = 128;
        int i1 = (i += this.drawOffsetX) + (j += this.drawOffsetY) * DrawingArea.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = DrawingArea.width - l1;
        int j2 = 0;
        if (j < DrawingArea.topY) {
            int k2 = DrawingArea.topY - j;
            k1 -= k2;
            j = DrawingArea.topY;
            j1 += k2 * l1;
            i1 += k2 * DrawingArea.width;
        }
        if (j + k1 > DrawingArea.bottomY) {
            k1 -= j + k1 - DrawingArea.bottomY;
        }
        if (i < DrawingArea.topX) {
            int l2 = DrawingArea.topX - i;
            l1 -= l2;
            i = DrawingArea.topX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > DrawingArea.bottomX) {
            int i3 = i + l1 - DrawingArea.bottomX;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.block_copy_alpha(j1, l1, DrawingArea.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    public void drawTransparentSprite(int i, int j, int opacity) {
        int k = opacity;
        int i1 = (i += this.drawOffsetX) + (j += this.drawOffsetY) * DrawingArea.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = DrawingArea.width - l1;
        int j2 = 0;
        if (j < DrawingArea.topY) {
            int k2 = DrawingArea.topY - j;
            k1 -= k2;
            j = DrawingArea.topY;
            j1 += k2 * l1;
            i1 += k2 * DrawingArea.width;
        }
        if (j + k1 > DrawingArea.bottomY) {
            k1 -= j + k1 - DrawingArea.bottomY;
        }
        if (i < DrawingArea.topX) {
            int l2 = DrawingArea.topX - i;
            l1 -= l2;
            i = DrawingArea.topX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > DrawingArea.bottomX) {
            int i3 = i + l1 - DrawingArea.bottomX;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.block_copy_alpha(j1, l1, DrawingArea.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    public void drawSprite(int i, int k) {
        int l = (i += this.drawOffsetX) + (k += this.drawOffsetY) * DrawingArea.width;
        int i1 = 0;
        int j1 = this.myHeight;
        int k1 = this.myWidth;
        int l1 = DrawingArea.width - k1;
        int i2 = 0;
        if (k < DrawingArea.topY) {
            int j2 = DrawingArea.topY - k;
            j1 -= j2;
            k = DrawingArea.topY;
            i1 += j2 * k1;
            l += j2 * DrawingArea.width;
        }
        if (k + j1 > DrawingArea.bottomY) {
            j1 -= k + j1 - DrawingArea.bottomY;
        }
        if (i < DrawingArea.topX) {
            int k2 = DrawingArea.topX - i;
            k1 -= k2;
            i = DrawingArea.topX;
            i1 += k2;
            l += k2;
            i2 += k2;
            l1 += k2;
        }
        if (i + k1 > DrawingArea.bottomX) {
            int l2 = i + k1 - DrawingArea.bottomX;
            k1 -= l2;
            i2 += l2;
            l1 += l2;
        }
        if (k1 > 0 && j1 > 0) {
            try {
                this.block_copy_trans(DrawingArea.pixels, this.myPixels, i1, l, k1, j1, l1, i2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void drawSpriteAlpha(int x, int y) {
        int destOffset = (x += this.drawOffsetX) + (y += this.drawOffsetY) * DrawingArea.width;
        int srcOffset = 0;
        int height = this.myHeight;
        int width = this.myWidth;
        int destStep = DrawingArea.width - width;
        int srcStep = 0;
        if (y < DrawingArea.topY) {
            int clipTop = DrawingArea.topY - y;
            height -= clipTop;
            y = DrawingArea.topY;
            srcOffset += clipTop * width;
            destOffset += clipTop * DrawingArea.width;
        }
        if (y + height > DrawingArea.bottomY) {
            height -= y + height - DrawingArea.bottomY;
        }
        if (x < DrawingArea.topX) {
            int clipLeft = DrawingArea.topX - x;
            width -= clipLeft;
            x = DrawingArea.topX;
            srcOffset += clipLeft;
            destOffset += clipLeft;
            srcStep += clipLeft;
            destStep += clipLeft;
        }
        if (x + width > DrawingArea.bottomX) {
            int clipRight = x + width - DrawingArea.bottomX;
            width -= clipRight;
            srcStep += clipRight;
            destStep += clipRight;
        }
        if (width > 0 && height > 0) {
            this.copyPixelsAlpha(DrawingArea.pixels, this.myPixels, srcOffset, destOffset, width, height, destStep, srcStep);
        }
    }

    private void copyPixelsAlpha(int[] dest, int[] src, int srcOffset, int destOffset, int width, int height, int destStep, int srcStep) {
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                int pixel;
                int alpha;
                if ((alpha = (pixel = src[srcOffset++]) >> 24 & 0xFF) == 255) {
                    dest[destOffset++] = pixel;
                    continue;
                }
                if (alpha == 0) {
                    ++destOffset;
                    continue;
                }
                int invAlpha = 256 - alpha;
                int destPixel = dest[destOffset];
                int r = (pixel & 0xFF0000) * alpha + (destPixel & 0xFF0000) * invAlpha >> 8 & 0xFF0000;
                int g = (pixel & 0xFF00) * alpha + (destPixel & 0xFF00) * invAlpha >> 8 & 0xFF00;
                int b = (pixel & 0xFF) * alpha + (destPixel & 0xFF) * invAlpha >> 8 & 0xFF;
                dest[destOffset++] = r | g | b;
            }
            srcOffset += srcStep;
            destOffset += destStep;
        }
    }

    public void drawSprite3(int x, int y, int opacity) {
        int alpha = opacity;
        int destOffset = (x += this.drawOffsetX) + (y += this.drawOffsetY) * DrawingArea.width;
        int srcOffset = 0;
        int height = this.myHeight;
        int width = this.myWidth;
        int destStep = DrawingArea.width - width;
        int srcStep = 0;
        if (y < DrawingArea.topY) {
            int trimHeight = DrawingArea.topY - y;
            height -= trimHeight;
            y = DrawingArea.topY;
            srcOffset += trimHeight * width;
            destOffset += trimHeight * DrawingArea.width;
        }
        if (y + height > DrawingArea.bottomY) {
            height -= y + height - DrawingArea.bottomY;
        }
        if (x < DrawingArea.topX) {
            int trimLeft = DrawingArea.topX - x;
            width -= trimLeft;
            x = DrawingArea.topX;
            srcOffset += trimLeft;
            destOffset += trimLeft;
            srcStep += trimLeft;
            destStep += trimLeft;
        }
        if (x + width > DrawingArea.bottomX) {
            int trimRight = x + width - DrawingArea.bottomX;
            width -= trimRight;
            srcStep += trimRight;
            destStep += trimRight;
        }
        if (width > 0 && height > 0) {
            this.setPixels(width, height, DrawingArea.pixels, this.myPixels, alpha, destOffset, srcOffset, destStep, srcStep);
        }
    }

    private void setPixels(int width, int height, int[] destPixels, int[] srcPixels, int srcAlpha, int destOffset, int srcOffset, int destStep, int srcStep) {
        int rofl = srcAlpha;
        for (int loop = -height; loop < 0; ++loop) {
            for (int loop2 = -width; loop2 < 0; ++loop2) {
                int srcColor;
                srcAlpha = this.myPixels[srcOffset] >> 24 & rofl;
                int destAlpha = 256 - srcAlpha;
                if ((srcColor = srcPixels[srcOffset++]) != 0 && srcColor != 0xFFFFFF) {
                    int destColor = destPixels[destOffset];
                    destPixels[destOffset++] = ((srcColor & 0xFF00FF) * srcAlpha + (destColor & 0xFF00FF) * destAlpha & 0xFF00FF00) + ((srcColor & 0xFF00) * srcAlpha + (destColor & 0xFF00) * destAlpha & 0xFF0000) >> 8;
                    continue;
                }
                ++destOffset;
            }
            destOffset += destStep;
            srcOffset += srcStep;
        }
    }

    public void drawSprite(int i, int k, int color) {
        int y;
        int x;
        this.autoUpdate();
        int tempWidth = this.myWidth + 2;
        int tempHeight = this.myHeight + 2;
        int[] tempArray = new int[tempWidth * tempHeight];
        for (x = 0; x < this.myWidth; ++x) {
            for (y = 0; y < this.myHeight; ++y) {
                if (this.myPixels[x + y * this.myWidth] == 0) continue;
                tempArray[x + 1 + (y + 1) * tempWidth] = this.myPixels[x + y * this.myWidth];
            }
        }
        for (x = 0; x < tempWidth; ++x) {
            for (y = 0; y < tempHeight; ++y) {
                if (tempArray[x + y * tempWidth] != 0) continue;
                if (x < tempWidth - 1 && tempArray[x + 1 + y * tempWidth] > 0 && tempArray[x + 1 + y * tempWidth] != 0xFFFFFF) {
                    tempArray[x + y * tempWidth] = color;
                }
                if (x > 0 && tempArray[x - 1 + y * tempWidth] > 0 && tempArray[x - 1 + y * tempWidth] != 0xFFFFFF) {
                    tempArray[x + y * tempWidth] = color;
                }
                if (y < tempHeight - 1 && tempArray[x + (y + 1) * tempWidth] > 0 && tempArray[x + (y + 1) * tempWidth] != 0xFFFFFF) {
                    tempArray[x + y * tempWidth] = color;
                }
                if (y <= 0 || tempArray[x + (y - 1) * tempWidth] <= 0 || tempArray[x + (y - 1) * tempWidth] == 0xFFFFFF) continue;
                tempArray[x + y * tempWidth] = color;
            }
        }
        --i;
        --k;
        int l = (i += this.drawOffsetX) + (k += this.drawOffsetY) * DrawingArea.width;
        int i1 = 0;
        int j1 = tempHeight;
        int k1 = tempWidth;
        int l1 = DrawingArea.width - k1;
        int i2 = 0;
        if (k < DrawingArea.topY) {
            int j2 = DrawingArea.topY - k;
            j1 -= j2;
            k = DrawingArea.topY;
            i1 += j2 * k1;
            l += j2 * DrawingArea.width;
        }
        if (k + j1 > DrawingArea.bottomY) {
            j1 -= k + j1 - DrawingArea.bottomY;
        }
        if (i < DrawingArea.topX) {
            int k2 = DrawingArea.topX - i;
            k1 -= k2;
            i = DrawingArea.topX;
            i1 += k2;
            l += k2;
            i2 += k2;
            l1 += k2;
        }
        if (i + k1 > DrawingArea.bottomX) {
            int l2 = i + k1 - DrawingArea.bottomX;
            k1 -= l2;
            i2 += l2;
            l1 += l2;
        }
        if (k1 > 0 && j1 > 0) {
            this.block_copy_trans(DrawingArea.pixels, tempArray, i1, l, k1, j1, l1, i2);
        }
    }

    public void drawSprite2(int i, int j) {
        int k = 225;
        int i1 = (i += this.drawOffsetX) + (j += this.drawOffsetY) * DrawingArea.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = DrawingArea.width - l1;
        int j2 = 0;
        if (j < DrawingArea.topY) {
            int k2 = DrawingArea.topY - j;
            k1 -= k2;
            j = DrawingArea.topY;
            j1 += k2 * l1;
            i1 += k2 * DrawingArea.width;
        }
        if (j + k1 > DrawingArea.bottomY) {
            k1 -= j + k1 - DrawingArea.bottomY;
        }
        if (i < DrawingArea.topX) {
            int l2 = DrawingArea.topX - i;
            l1 -= l2;
            i = DrawingArea.topX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > DrawingArea.bottomX) {
            int i3 = i + l1 - DrawingArea.bottomX;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.block_copy_alpha(j1, l1, DrawingArea.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    public void block_copy_trans(int[] ai, int[] ai1, int j, int k, int l, int i1, int j1, int k1) {
        int l1 = -(l >> 2);
        l = -(l & 3);
        for (int i2 = -i1; i2 < 0; ++i2) {
            int i;
            for (int j2 = l1; j2 < 0; ++j2) {
                if ((i = ai1[j++]) != 0 && i != -1) {
                    ai[k++] = i;
                } else {
                    ++k;
                }
                i = ai1[j++];
                if (i != 0 && i != -1) {
                    ai[k++] = i;
                } else {
                    ++k;
                }
                i = ai1[j++];
                if (i != 0 && i != -1) {
                    ai[k++] = i;
                } else {
                    ++k;
                }
                i = ai1[j++];
                if (i != 0 && i != -1) {
                    ai[k++] = i;
                    continue;
                }
                ++k;
            }
            for (int k2 = l; k2 < 0; ++k2) {
                if ((i = ai1[j++]) != 0 && i != -1) {
                    ai[k++] = i;
                    continue;
                }
                ++k;
            }
            k += j1;
            j += k1;
        }
    }

    public void block_copy_alpha(int i, int j, int[] ai, int[] ai1, int l, int i1, int j1, int k1, int l1) {
        int j2 = 256 - k1;
        for (int k2 = -i1; k2 < 0; ++k2) {
            for (int l2 = -j; l2 < 0; ++l2) {
                int k;
                if ((k = ai1[i++]) != 0) {
                    int i3 = ai[l1];
                    ai[l1++] = ((k & 0xFF00FF) * k1 + (i3 & 0xFF00FF) * j2 & 0xFF00FF00) + ((k & 0xFF00) * k1 + (i3 & 0xFF00) * j2 & 0xFF0000) >> 8;
                    continue;
                }
                ++l1;
            }
            l1 += j1;
            i += l;
        }
    }

    public void rotate(int dimension, int rotation, int[] yPosArray, int zoom, int[] xPosArray, int basePosition, int yPosition, int xPosition, int dimension_1, int middle) {
        this.autoUpdate();
        try {
            int j2 = -dimension_1 / 2;
            int k2 = -dimension / 2;
            int l2 = (int)(Math.sin((double)rotation / 326.11) * 65536.0);
            int i3 = (int)(Math.cos((double)rotation / 326.11) * 65536.0);
            l2 = l2 * zoom >> 8;
            i3 = i3 * zoom >> 8;
            int j3 = (middle << 16) + (k2 * l2 + j2 * i3);
            int k3 = (basePosition << 16) + (k2 * i3 - j2 * l2);
            int l3 = xPosition + yPosition * DrawingArea.width;
            for (yPosition = 0; yPosition < dimension; ++yPosition) {
                int i4 = xPosArray[yPosition];
                int j4 = l3 + i4;
                int k4 = j3 + i3 * i4;
                int l4 = k3 - l2 * i4;
                for (xPosition = -yPosArray[yPosition]; xPosition < 0; ++xPosition) {
                    int x1 = k4 >> 16;
                    int y1 = l4 >> 16;
                    int x2 = x1 + 1;
                    int y2 = y1 + 1;
                    int c1 = this.myPixels[x1 + y1 * this.myWidth];
                    int c2 = this.myPixels[x2 + y1 * this.myWidth];
                    int c3 = this.myPixels[x1 + y2 * this.myWidth];
                    int c4 = this.myPixels[x2 + y2 * this.myWidth];
                    int u1 = (k4 >> 8) - (x1 << 8);
                    int v1 = (l4 >> 8) - (y1 << 8);
                    int u2 = (x2 << 8) - (k4 >> 8);
                    int v2 = (y2 << 8) - (l4 >> 8);
                    int a1 = u2 * v2;
                    int a2 = u1 * v2;
                    int a3 = u2 * v1;
                    int a4 = u1 * v1;
                    int r = (c1 >> 16 & 0xFF) * a1 + (c2 >> 16 & 0xFF) * a2 + (c3 >> 16 & 0xFF) * a3 + (c4 >> 16 & 0xFF) * a4 & 0xFF0000;
                    int g = (c1 >> 8 & 0xFF) * a1 + (c2 >> 8 & 0xFF) * a2 + (c3 >> 8 & 0xFF) * a3 + (c4 >> 8 & 0xFF) * a4 >> 8 & 0xFF00;
                    int b = (c1 & 0xFF) * a1 + (c2 & 0xFF) * a2 + (c3 & 0xFF) * a3 + (c4 & 0xFF) * a4 >> 16;
                    DrawingArea.pixels[j4++] = r | g | b;
                    k4 += i3;
                    l4 -= l2;
                }
                j3 += l2;
                k3 += i3;
                l3 += DrawingArea.width;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void rotate(int y, double d, int x) {
        this.autoUpdate();
        int j = 15;
        int k = 20;
        int l = 15;
        int j1 = 256;
        int k1 = 20;
        try {
            int i2 = -k / 2;
            int j2 = -k1 / 2;
            int k2 = (int)(Math.sin(d) * 65536.0);
            int l2 = (int)(Math.cos(d) * 65536.0);
            k2 = k2 * j1 >> 8;
            l2 = l2 * j1 >> 8;
            int i3 = (l << 16) + (j2 * k2 + i2 * l2);
            int j3 = (j << 16) + (j2 * l2 - i2 * k2);
            int k3 = x + y * DrawingArea.width;
            for (y = 0; y < k1; ++y) {
                int l3 = k3;
                int i4 = i3;
                int j4 = j3;
                for (x = -k; x < 0; ++x) {
                    int k4 = this.myPixels[(i4 >> 16) + (j4 >> 16) * this.myWidth];
                    if (k4 != 0) {
                        DrawingArea.pixels[l3++] = k4;
                    } else {
                        ++l3;
                    }
                    i4 += l2;
                    j4 -= k2;
                }
                i3 += k2;
                j3 += l2;
                k3 += DrawingArea.width;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void draw(Background background, int i, int j) {
        this.autoUpdate();
        int k = (j += this.drawOffsetX) + (i += this.drawOffsetY) * DrawingArea.width;
        int l = 0;
        int i1 = this.myHeight;
        int j1 = this.myWidth;
        int k1 = DrawingArea.width - j1;
        int l1 = 0;
        if (i < DrawingArea.topY) {
            int i2 = DrawingArea.topY - i;
            i1 -= i2;
            i = DrawingArea.topY;
            l += i2 * j1;
            k += i2 * DrawingArea.width;
        }
        if (i + i1 > DrawingArea.bottomY) {
            i1 -= i + i1 - DrawingArea.bottomY;
        }
        if (j < DrawingArea.topX) {
            int j2 = DrawingArea.topX - j;
            j1 -= j2;
            j = DrawingArea.topX;
            l += j2;
            k += j2;
            l1 += j2;
            k1 += j2;
        }
        if (j + j1 > DrawingArea.bottomX) {
            int k2 = j + j1 - DrawingArea.bottomX;
            j1 -= k2;
            l1 += k2;
            k1 += k2;
        }
        if (j1 > 0 && i1 > 0) {
            this.block_copy_mask(this.myPixels, j1, background.imgPixels, i1, DrawingArea.pixels, 0, k1, k, l1, l);
        }
    }

    public void greyScale() {
        for (int index = 0; index < this.myWidth * this.myHeight; ++index) {
            int alpha = this.myPixels[index] >>> 24;
            int red = this.myPixels[index] >>> 16 & 0xFF;
            int green = this.myPixels[index] >>> 8 & 0xFF;
            int blue = this.myPixels[index] & 0xFF;
            int delta = (red + green + blue) / 3;
            this.myPixels[index] = delta | delta << 8 | delta << 16 | alpha << 24;
        }
    }

    public void drawSpriteWithOpacity(int xPos, int yPos, int o) {
        int opacity = o;
        int i1 = (xPos += this.drawOffsetX) + (yPos += this.drawOffsetY) * DrawingArea.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = DrawingArea.width - l1;
        int j2 = 0;
        if (yPos < DrawingArea.topY) {
            int k2 = DrawingArea.topY - yPos;
            k1 -= k2;
            yPos = DrawingArea.topY;
            j1 += k2 * l1;
            i1 += k2 * DrawingArea.width;
        }
        if (yPos + k1 > DrawingArea.bottomY) {
            k1 -= yPos + k1 - DrawingArea.bottomY;
        }
        if (xPos < DrawingArea.topX) {
            int l2 = DrawingArea.topX - xPos;
            l1 -= l2;
            xPos = DrawingArea.topX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (xPos + l1 > DrawingArea.bottomX) {
            int i3 = xPos + l1 - DrawingArea.bottomX;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.block_copy_alpha(j1, l1, DrawingArea.pixels, this.myPixels, j2, k1, i2, opacity, i1);
        }
    }

    public void block_copy_mask(int[] ai, int i, byte[] abyte0, int j, int[] ai1, int k, int l, int i1, int j1, int k1) {
        int l1 = -(i >> 2);
        i = -(i & 3);
        for (int j2 = -j; j2 < 0; ++j2) {
            for (int k2 = l1; k2 < 0; ++k2) {
                if ((k = ai[k1++]) != 0 && abyte0[i1] == 0) {
                    ai1[i1++] = k;
                } else {
                    ++i1;
                }
                k = ai[k1++];
                if (k != 0 && abyte0[i1] == 0) {
                    ai1[i1++] = k;
                } else {
                    ++i1;
                }
                k = ai[k1++];
                if (k != 0 && abyte0[i1] == 0) {
                    ai1[i1++] = k;
                } else {
                    ++i1;
                }
                k = ai[k1++];
                if (k != 0 && abyte0[i1] == 0) {
                    ai1[i1++] = k;
                    continue;
                }
                ++i1;
            }
            for (int l2 = i; l2 < 0; ++l2) {
                if ((k = ai[k1++]) != 0 && abyte0[i1] == 0) {
                    ai1[i1++] = k;
                    continue;
                }
                ++i1;
            }
            i1 += l;
            k1 += j1;
        }
    }

    public void drawARGBSprite(int xPos, int yPos) {
        this.drawARGBSprite(xPos, yPos, 256);
    }

    public void autoUpdate() {
    }

    public Sprite() {
    }
}

