/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.CacheArchive;
import com.teragard.FileOperations;
import com.teragard.Sprite;
import com.teragard.Stream;
import com.teragard.signlink;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.GZIPInputStream;

public class SpriteLoader {
    public static SpriteLoader[] cache;
    public static Sprite[] sprites;
    public static int totalSprites;
    public String name = "name";
    public int id = -1;
    public int drawOffsetX = 0;
    public int drawOffsetY = 0;
    public byte[] spriteData = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSprites(CacheArchive CacheArchive2) {
        FilterInputStream indexFile = null;
        FilterInputStream dataFile = null;
        try {
            Stream index = new Stream(FileOperations.readFile(signlink.findcachedir() + "sprites.idx"));
            Stream data = new Stream(FileOperations.readFile(signlink.findcachedir() + "sprites.dat"));
            indexFile = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(index.buffer)));
            dataFile = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(data.buffer)));
            int totalSprites = ((DataInputStream)indexFile).readInt();
            if (cache == null) {
                cache = new SpriteLoader[totalSprites];
                sprites = new Sprite[totalSprites];
            }
            for (int i = 0; i < totalSprites; ++i) {
                try {
                    int id = ((DataInputStream)indexFile).readInt();
                    if (cache[id] == null) {
                        SpriteLoader.cache[id] = new SpriteLoader();
                    }
                    cache[id].readValues((DataInputStream)dataFile, (DataInputStream)indexFile);
                    SpriteLoader.createSprite(cache[id], false);
                    continue;
                }
                catch (Exception spriteEx) {
                    System.err.println("[SpriteLoader] Error loading sprite at index " + i + ": " + spriteEx.getMessage());
                }
            }
            indexFile.close();
            dataFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (indexFile != null) {
                    indexFile.close();
                }
                if (dataFile != null) {
                    dataFile.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void readValues(DataInputStream data, DataInputStream indexFile) throws IOException {
        byte opCode;
        while ((opCode = data.readByte()) != 0) {
            if (opCode == 1) {
                this.id = data.readShort();
                continue;
            }
            if (opCode == 2) {
                this.name = data.readUTF();
                continue;
            }
            if (opCode == 3) {
                this.drawOffsetX = data.readShort();
                continue;
            }
            if (opCode == 4) {
                this.drawOffsetY = data.readShort();
                continue;
            }
            if (opCode != 5) continue;
            byte[] dataread = new byte[indexFile.readInt()];
            data.readFully(dataread);
            this.spriteData = dataread;
        }
        return;
    }

    public static void createSprite(SpriteLoader sprite, boolean second) {
        if (!second && sprite.spriteData != null) {
            SpriteLoader.sprites[sprite.id] = new Sprite(sprite.spriteData);
            SpriteLoader.sprites[sprite.id].drawOffsetX = sprite.drawOffsetX;
            SpriteLoader.sprites[sprite.id].drawOffsetY = sprite.drawOffsetY;
        }
    }

    private static void writeFile(File f, byte[] data) {
        try (RandomAccessFile raf = new RandomAccessFile(f, "rw");){
            raf.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getName(int index) {
        if (SpriteLoader.cache[index].name != null) {
            return SpriteLoader.cache[index].name;
        }
        return "null";
    }

    public static int getOffsetX(int index) {
        return SpriteLoader.cache[index].drawOffsetX;
    }

    public static int getOffsetY(int index) {
        return SpriteLoader.cache[index].drawOffsetY;
    }

    static {
        sprites = null;
    }
}

