/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.Client;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public class SwingUI
extends Client
implements ActionListener {
    private static JMenuItem menuItem;
    private JFrame frame;

    public SwingUI(String[] args) {
        try {
            this.initUI();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void initUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            JFrame.setDefaultLookAndFeelDecorated(true);
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            this.frame = new JFrame("Teragard Reborn");
            this.frame.setLayout(new BorderLayout());
            this.frame.setResizable(false);
            this.frame.setDefaultCloseOperation(3);
            JPanel gamePanel = new JPanel();
            gamePanel.setLayout(new BorderLayout());
            gamePanel.add(this);
            gamePanel.setPreferredSize(new Dimension(765, 524));
            this.initMenubar();
            this.frame.getContentPane().add((Component)gamePanel, "Center");
            this.frame.pack();
            this.frame.setVisible(true);
            this.frame.setResizable(false);
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initMenubar() {
        String[] mainButtons;
        JMenu fileMenu = new JMenu("File");
        for (String name : mainButtons = new String[]{"Forums", "-", "Exit"}) {
            JMenuItem menuItem = new JMenuItem(name);
            if (name.equalsIgnoreCase("-")) {
                fileMenu.addSeparator();
                continue;
            }
            if (name.equalsIgnoreCase("Forums")) {
                JMenu forumsMenu = new JMenu("Forums");
                fileMenu.add(forumsMenu);
                JMenuItem runeServer = new JMenuItem("Rune-Server");
                runeServer.addActionListener(this);
                forumsMenu.add(runeServer);
                continue;
            }
            menuItem.addActionListener(this);
            fileMenu.add(menuItem);
        }
        JMenuBar menuBar = new JMenuBar();
        JMenuBar jmenubar = new JMenuBar();
        this.frame.add(jmenubar);
        menuBar.add(fileMenu);
        this.frame.getContentPane().add((Component)menuBar, "North");
    }

    private static void openURL(String url) {
        Desktop d = Desktop.getDesktop();
        try {
            d.browse(new URI(url));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        try {
            if (cmd != null) {
                if (cmd.equalsIgnoreCase("exit")) {
                    System.exit(0);
                } else if (cmd.equalsIgnoreCase("Rune-Server")) {
                    SwingUI.openURL("http://www.rune-server.org/forums.php");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

