/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.TextDrawingArea;

public final class TextClass {
    private static final char[] validChars = new char[]{'_', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public static long longForName(String s) {
        long l = 0L;
        for (int i = 0; i < s.length() && i < 12; ++i) {
            char c = s.charAt(i);
            l *= 37L;
            if (c >= 'A' && c <= 'Z') {
                l += (long)('\u0001' + c - 65);
                continue;
            }
            if (c >= 'a' && c <= 'z') {
                l += (long)('\u0001' + c - 97);
                continue;
            }
            if (c < '0' || c > '9') continue;
            l += (long)(27 + c - 48);
        }
        while (l % 37L == 0L && l != 0L) {
            l /= 37L;
        }
        return l;
    }

    public static String nameForLong(long l) {
        try {
            if (l <= 0L || l >= 6582952005840035281L) {
                return "invalid_name";
            }
            if (l % 37L == 0L) {
                return "invalid_name";
            }
            int i = 0;
            char[] ac = new char[12];
            while (l != 0L) {
                long l1 = l;
                ac[11 - i++] = validChars[(int)(l1 - (l /= 37L) * 37L)];
            }
            return new String(ac, 12 - i, i);
        }
        catch (RuntimeException runtimeexception) {
            System.out.println("81570, " + l + ", -99, " + runtimeexception.toString());
            throw new RuntimeException();
        }
    }

    public static long method585(String s) {
        s = s.toUpperCase();
        long l = 0L;
        for (int i = 0; i < s.length(); ++i) {
            l = l * 61L + (long)s.charAt(i) - 32L;
            l = l + (l >> 56) & 0xFFFFFFFFFFFFFFL;
        }
        return l;
    }

    public static String method586(int i) {
        return (i >> 24 & 0xFF) + "." + (i >> 16 & 0xFF) + "." + (i >> 8 & 0xFF) + "." + (i & 0xFF);
    }

    public static String fixName(String s) {
        if (s == null) {
            return "";
        }
        if (s.length() > 0) {
            char[] ac = s.toCharArray();
            for (int j = 0; j < ac.length; ++j) {
                if (ac[j] != '_') continue;
                ac[j] = 32;
                if (j + 1 >= ac.length || ac[j + 1] < 'a' || ac[j + 1] > 'z') continue;
                ac[j + 1] = (char)(ac[j + 1] + 65 - 97);
            }
            if (ac[0] >= 'a' && ac[0] <= 'z') {
                ac[0] = (char)(ac[0] + 65 - 97);
            }
            return new String(ac);
        }
        return s;
    }

    public static String[] splitString(TextDrawingArea font, String prefix, String string, int maxWidth, boolean ranked) {
        if (font.getTextWidth(prefix + string) + (ranked ? 14 : 0) <= (maxWidth -= font.getTextWidth(prefix) + (ranked ? 14 : 0))) {
            return new String[]{string};
        }
        Object line = "";
        String[] cut = new String[2];
        boolean split = false;
        char[] characters = string.toCharArray();
        int space = -1;
        for (int index = 0; index < characters.length; ++index) {
            char c = characters[index];
            line = (String)line + c;
            if (c == ' ') {
                space = index;
            }
            if (split || font.getTextWidth((String)line) + 10 <= maxWidth) continue;
            if (space != -1 && characters[index - 1] != ' ') {
                cut[0] = ((String)line).substring(0, space);
                line = ((String)line).substring(space);
            } else {
                cut[0] = line;
                line = "";
            }
            split = true;
        }
        if (((String)line).length() > 0) {
            cut[1] = line;
        }
        return cut;
    }

    public static boolean isAlphanumeric(String string) {
        return string.matches("[A-Za-z0-9 ]+");
    }

    public static boolean isValidName(String name) {
        if (name.contains("  ") || name.contains("   ") || name.contains("    ") || name.contains("     ") || name.contains("      ") || name.contains("       ") || name.contains("        ") || name.contains("         ") || name.contains("          ") || name.contains("           ") || name.contains("            ")) {
            return false;
        }
        return name.matches("[A-Za-z0-9 ]+");
    }

    public static boolean isValidEmail(String email) {
        return email.matches(".+@.+\\.[a-z]+");
    }

    public static String passwordAsterisks(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer stringbuffer = new StringBuffer();
        for (int j = 0; j < s.length(); ++j) {
            stringbuffer.append("*");
        }
        return stringbuffer.toString();
    }
}

