/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.ARGBTexture;
import com.teragard.AlphaPalettedTexture;
import com.teragard.ByteBuffer;
import com.teragard.OnDemandFetcher;
import com.teragard.PalettedTexture;
import com.teragard.RGBTexture;

public class Texture {
    public boolean opaque;
    public boolean hasAlpha;
    public final int width;
    public final int height;
    private static boolean[] loaded;
    private static Texture[] textures;
    static OnDemandFetcher updateManager;
    public static Texture NULL_TEXTURE;

    public Texture(int width, int height) {
        this.width = width;
        this.height = height;
        this.opaque = true;
    }

    public int getPixel(int i) {
        return -1;
    }

    public static Texture get(int id) {
        if (id < 0 || id >= textures.length) {
            return null;
        }
        if (loaded[id]) {
            return textures[id];
        }
        updateManager.requestFileData(5, id);
        return null;
    }

    public static void init(int count, OnDemandFetcher updateManager_) {
        textures = new Texture[count];
        loaded = new boolean[count];
        updateManager = updateManager_;
    }

    public static void load(int id, byte[] data) {
        Texture.loaded[id] = true;
        if (data != null && data.length >= 5) {
            ByteBuffer buffer = new ByteBuffer(data);
            int type = buffer.readUnsignedByte();
            int width = buffer.readUnsignedWord();
            int height = buffer.readUnsignedWord();
            if (type == 0) {
                Texture.textures[id] = new PalettedTexture(width, height, buffer, false);
            } else if (type == 1) {
                Texture.textures[id] = new RGBTexture(width, height, buffer);
            } else if (type == 2) {
                Texture.textures[id] = new AlphaPalettedTexture(width, height, buffer);
            } else if (type == 3) {
                Texture.textures[id] = new ARGBTexture(width, height, buffer);
            }
        }
    }

    public String toString() {
        return this.width + " X " + this.height + "\t" + (this.opaque ? "+opaque" : "-opaque") + "\t" + (this.hasAlpha ? "+alpha" : "-alpha");
    }

    public static void nullLoader() {
        loaded = null;
        textures = null;
        updateManager = null;
    }

    public static int getTotal() {
        return textures.length;
    }

    static {
        NULL_TEXTURE = new Texture(64, 64);
    }
}

