/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.Background;
import com.teragard.CacheArchive;
import com.teragard.Client;
import com.teragard.Rasterizer;
import com.teragard.TextureLoader667;

public class TextureLoader317 {
    public static int textureammount = 72;
    private static int[][] texturePalettes = new int[textureammount][];
    private static int loadedTextureCount;
    public static Background[] textureImages;
    public static boolean[] textureIsTransparent;
    private static int[] averageTextureColour;
    private static int[][] texelCache;
    public static int[] textureLastUsed;
    private static int textureTexelPoolPointer;
    private static int[][] texelArrayPool;
    public static int textureGetCount;

    public static void clear() {
        textureImages = null;
        textureIsTransparent = null;
        averageTextureColour = null;
        texelArrayPool = null;
        texelCache = null;
        textureLastUsed = null;
        texturePalettes = null;
    }

    public static void calculateTexturePalette(double brightness) {
        for (int l = 0; l < 72; ++l) {
            if (textureImages[l] == null) continue;
            int[] ai = TextureLoader317.textureImages[l].palette;
            TextureLoader317.texturePalettes[l] = new int[ai.length];
            for (int j1 = 0; j1 < ai.length; ++j1) {
                TextureLoader317.texturePalettes[l][j1] = Rasterizer.adjustBrightness(ai[j1], brightness);
                if ((texturePalettes[l][j1] & 0xF8F8FF) != 0 || j1 == 0) continue;
                TextureLoader317.texturePalettes[l][j1] = 1;
            }
        }
        for (int i1 = 0; i1 < 72; ++i1) {
            TextureLoader317.resetTexture(i1);
        }
    }

    public static void clearTextureCache() {
        texelArrayPool = null;
        for (int j = 0; j < 72; ++j) {
            TextureLoader317.texelCache[j] = null;
        }
    }

    public static void resetTextures() {
        if (Client.getOption("hd_tex")) {
            TextureLoader667.resetTextures();
            return;
        }
        if (texelArrayPool == null) {
            textureTexelPoolPointer = 20;
            texelArrayPool = Rasterizer.lowMem ? new int[textureTexelPoolPointer][16384] : new int[textureTexelPoolPointer][65536];
            for (int k = 0; k < 72; ++k) {
                TextureLoader317.texelCache[k] = null;
            }
        }
    }

    public static void unpackTextures(CacheArchive streamLoader) {
        loadedTextureCount = 0;
        for (int j = 0; j < textureammount; ++j) {
            try {
                TextureLoader317.textureImages[j] = new Background(streamLoader, String.valueOf(j), 0);
                if (Rasterizer.lowMem && TextureLoader317.textureImages[j].libWidth == 128) {
                    textureImages[j].reduceSetOffset();
                } else {
                    textureImages[j].setOffset();
                }
                ++loadedTextureCount;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int getAverageTextureColour(int textureId) {
        if (averageTextureColour[textureId] != 0) {
            return averageTextureColour[textureId];
        }
        int red = 0;
        int green = 0;
        int blue = 0;
        int colourCount = texturePalettes[textureId].length;
        for (int k1 = 0; k1 < colourCount; ++k1) {
            red += texturePalettes[textureId][k1] >> 16 & 0xFF;
            green += texturePalettes[textureId][k1] >> 8 & 0xFF;
            blue += texturePalettes[textureId][k1] & 0xFF;
        }
        int rgb = (red / colourCount << 16) + (green / colourCount << 8) + blue / colourCount;
        rgb = Rasterizer.adjustBrightness(rgb, 1.4);
        if (textureId == 1 || textureId == 24) {
            rgb = TextureLoader317.adjustBrightnessLinear(rgb, 679);
            rgb = Rasterizer.adjustBrightness(rgb, 4.8f);
        } else {
            rgb = Rasterizer.adjustBrightness(rgb, 1.4);
        }
        if (rgb == 0) {
            rgb = 1;
        }
        TextureLoader317.averageTextureColour[textureId] = rgb;
        return rgb;
    }

    private static int adjustBrightnessLinear(int rgb, int factor) {
        return ((rgb >>> 16) * factor & 0xFF00) << 8 | (rgb >>> 8 & 0xFF) * factor & 0xFF00 | (rgb & 0xFF) * factor >> 8;
    }

    public static void resetTexture(int textureId) {
        if (texelCache[textureId] == null) {
            return;
        }
        TextureLoader317.texelArrayPool[TextureLoader317.textureTexelPoolPointer++] = texelCache[textureId];
        TextureLoader317.texelCache[textureId] = null;
    }

    public static int[] getTexturePixels(int textureId) {
        int[] ai;
        if (textureId == 1) {
            textureId = 24;
        }
        ++textureGetCount;
        if (texelCache[textureId] != null) {
            return texelCache[textureId];
        }
        if (textureTexelPoolPointer > 0) {
            ai = texelArrayPool[--textureTexelPoolPointer];
            TextureLoader317.texelArrayPool[TextureLoader317.textureTexelPoolPointer] = null;
        } else {
            int j = 0;
            int k = -1;
            for (int l = 0; l < loadedTextureCount; ++l) {
                if (texelCache[l] == null || textureLastUsed[l] >= j && k != -1) continue;
                j = textureLastUsed[l];
                k = l;
            }
            ai = texelCache[k];
            TextureLoader317.texelCache[k] = null;
        }
        TextureLoader317.texelCache[textureId] = ai;
        Background background = textureImages[textureId];
        int[] ai1 = texturePalettes[textureId];
        if (Rasterizer.lowMem) {
            TextureLoader317.textureIsTransparent[textureId] = false;
            for (int i1 = 0; i1 < 4096; ++i1) {
                ai[i1] = ai1[background.imgPixels[i1]] & 0xF8F8FF;
                int i2 = ai[i1];
                if (i2 == 0) {
                    TextureLoader317.textureIsTransparent[textureId] = true;
                }
                ai[4096 + i1] = i2 - (i2 >>> 3) & 0xF8F8FF;
                ai[8192 + i1] = i2 - (i2 >>> 2) & 0xF8F8FF;
                ai[12288 + i1] = i2 - (i2 >>> 2) - (i2 >>> 3) & 0xF8F8FF;
            }
        } else {
            if (background.imgWidth == 64) {
                for (int j1 = 0; j1 < 128; ++j1) {
                    for (int j2 = 0; j2 < 128; ++j2) {
                        ai[j2 + (j1 << 7)] = ai1[background.imgPixels[(j2 >> 1) + (j1 >> 1 << 6)]];
                    }
                }
            } else {
                for (int k1 = 0; k1 < 16384; ++k1) {
                    ai[k1] = ai1[background.imgPixels[k1]];
                }
            }
            TextureLoader317.textureIsTransparent[textureId] = false;
            for (int l1 = 0; l1 < 16384; ++l1) {
                int n = l1;
                ai[n] = ai[n] & 0xF8F8FF;
                int k2 = ai[l1];
                if (k2 == 0) {
                    TextureLoader317.textureIsTransparent[textureId] = true;
                }
                ai[16384 + l1] = k2 - (k2 >>> 3) & 0xF8F8FF;
                ai[32768 + l1] = k2 - (k2 >>> 2) & 0xF8F8FF;
                ai[49152 + l1] = k2 - (k2 >>> 2) - (k2 >>> 3) & 0xF8F8FF;
            }
        }
        return ai;
    }

    static {
        textureImages = new Background[textureammount];
        textureIsTransparent = new boolean[textureammount];
        averageTextureColour = new int[textureammount];
        texelCache = new int[textureammount][];
        textureLastUsed = new int[textureammount];
    }
}

