/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.OnDemandFetcher;
import com.teragard.Texture;
import com.teragard.TextureDef;

public class TextureLoader667 {
    private static int loadedTextureCount;
    private static int textureTexelPoolPointer;
    private static int[][] texelArrayPool;
    private static int[][] texelCache;
    public static int[] textureLastUsed;
    public static int textureGetCount;
    private static float brightness;

    public static void initTextures(int count, OnDemandFetcher updateManager_) {
        Texture.init(count, updateManager_);
        loadedTextureCount = count;
        textureLastUsed = new int[count];
        texelCache = new int[count][];
    }

    public static void clearTextureCache() {
        texelArrayPool = null;
        for (int i = 0; i < loadedTextureCount; ++i) {
            TextureLoader667.texelCache[i] = null;
        }
    }

    public static void resetTextures() {
        if (texelArrayPool == null) {
            textureTexelPoolPointer = 50;
            texelArrayPool = new int[textureTexelPoolPointer][65536];
            for (int k = 0; k < loadedTextureCount; ++k) {
                TextureLoader667.texelCache[k] = null;
            }
        }
    }

    public static void resetTexture(int textureId) {
        if (texelCache[textureId] == null) {
            return;
        }
        TextureLoader667.texelArrayPool[TextureLoader667.textureTexelPoolPointer++] = texelCache[textureId];
        TextureLoader667.texelCache[textureId] = null;
    }

    public static int[] getTexturePixels(int textureId) {
        int blendType;
        int[] texels;
        Texture texture;
        if (textureId == 0) {
            textureId = 24;
        }
        if ((texture = Texture.get(textureId)) == null) {
            return null;
        }
        ++textureGetCount;
        if (texelCache[textureId] != null) {
            return texelCache[textureId];
        }
        if (textureTexelPoolPointer > 0) {
            texels = texelArrayPool[--textureTexelPoolPointer];
            TextureLoader667.texelArrayPool[TextureLoader667.textureTexelPoolPointer] = null;
        } else {
            int lastUsed = 0;
            int target = -1;
            for (int i = 0; i < loadedTextureCount; ++i) {
                if (texelCache[i] == null || textureLastUsed[i] >= lastUsed && target != -1) continue;
                lastUsed = textureLastUsed[i];
                target = i;
            }
            texels = texelCache[target];
            TextureLoader667.texelCache[target] = null;
        }
        TextureLoader667.texelCache[textureId] = texels;
        if (texture.width == 64) {
            for (int y = 0; y < 128; ++y) {
                for (int x = 0; x < 128; ++x) {
                    texels[x + (y << 7)] = texture.getPixel((x >> 1) + (y >> 1 << 6));
                }
            }
        } else {
            for (int texelPtr = 0; texelPtr < 16384; ++texelPtr) {
                texels[texelPtr] = texture.getPixel(texelPtr);
            }
        }
        TextureDef def = textureId >= 0 && textureId < TextureDef.textures.length ? TextureDef.textures[textureId] : null;
        int n = blendType = def != null ? def.anInt1226 : 0;
        if (blendType != 1 && blendType != 2) {
            blendType = 0;
        }
        for (int texelPtr = 0; texelPtr < 16384; ++texelPtr) {
            int alpha;
            int texel = texels[texelPtr];
            if (blendType == 2) {
                alpha = texel >>> 24;
            } else if (blendType == 1) {
                alpha = texel != 0 ? 255 : 0;
            } else {
                alpha = texel >>> 24;
                if (def != null && !def.aBoolean1223) {
                    alpha /= 5;
                }
            }
            texel &= 0xFFFFFF;
            texel = textureId == 1 || textureId == 24 ? TextureLoader667.adjustBrightnessLinear(texel, 379) : TextureLoader667.adjustBrightnessLinear(texel, 179);
            texel = textureId == 1 || textureId == 24 ? TextureLoader667.adjustBrightness(texel, 0.90093f) : TextureLoader667.adjustBrightness(texel, brightness);
            texels[texelPtr] = (texel &= 0xF8F8FF) | alpha << 24;
            texels[16384 + texelPtr] = texel - (texel >>> 3) & 0xF8F8FF | alpha << 24;
            texels[32768 + texelPtr] = texel - (texel >>> 2) & 0xF8F8FF | alpha << 24;
            texels[49152 + texelPtr] = texel - (texel >>> 3) - (texel >>> 3) & 0xF8F8FF | alpha << 24;
        }
        return texels;
    }

    public boolean isValid() {
        return texelArrayPool != null && texelCache != null;
    }

    private static int adjustBrightness(int rgb, float brightness) {
        return (int)((float)Math.pow((float)(rgb >>> 16) / 256.0f, brightness) * 256.0f) << 16 | (int)((float)Math.pow((float)(rgb >>> 8 & 0xFF) / 256.0f, brightness) * 256.0f) << 8 | (int)((float)Math.pow((float)(rgb & 0xFF) / 256.0f, brightness) * 256.0f);
    }

    private static int adjustBrightnessLinear(int rgb, int factor) {
        return ((rgb >>> 16) * factor & 0xFF00) << 8 | (rgb >>> 8 & 0xFF) * factor & 0xFF00 | (rgb & 0xFF) * factor >> 8;
    }

    public static void calculateTexturePalette(double brightness) {
        for (int textureId = 0; textureId != loadedTextureCount; ++textureId) {
            TextureLoader667.resetTexture(textureId);
        }
    }

    public static void clear() {
        texelArrayPool = null;
        texelCache = null;
        textureLastUsed = null;
        brightness = 1.0f;
    }

    static {
        brightness = 1.0f;
    }
}

