/*
 * Decompiled with CFR 0.152.
 */
package com.teragard.components;

import com.teragard.RSInterface;
import com.teragard.RSInterfaceBuilder;

public class ContainerComponent {
    private final RSInterfaceBuilder builder;
    private int currentChildIndex = 0;

    private ContainerComponent(int id) {
        this.builder = RSInterfaceBuilder.create(id).type(0);
    }

    public static ContainerComponent create(int id) {
        return new ContainerComponent(id);
    }

    public ContainerComponent size(int width, int height) {
        this.builder.size(width, height);
        return this;
    }

    public ContainerComponent scroll(int scrollMax) {
        this.builder.scroll(scrollMax);
        return this;
    }

    public ContainerComponent shown(boolean shown) {
        this.builder.shown(shown);
        return this;
    }

    public ContainerComponent childCount(int count) {
        this.builder.children(count);
        return this;
    }

    public ContainerComponent child(int index, int childId, int x, int y) {
        this.builder.child(index, childId, x, y);
        return this;
    }

    public ContainerComponent addChild(int childId, int x, int y) {
        this.builder.child(this.currentChildIndex++, childId, x, y);
        return this;
    }

    public ContainerComponent opacity(int opacity) {
        this.builder.opacity(opacity);
        return this;
    }

    public ContainerComponent transparent() {
        this.builder.transparent(true);
        return this;
    }

    public RSInterface build() {
        return this.builder.build();
    }

    public int getChildIndex() {
        return this.currentChildIndex;
    }

    public static ContainerComponent tab(int id) {
        return new ContainerComponent(id);
    }

    public static ContainerComponent scrollPanel(int id, int width, int height, int scrollHeight) {
        return ContainerComponent.create(id).size(width, height).scroll(scrollHeight);
    }
}

