/*
 * Decompiled with CFR 0.152.
 */
package com.teragard.components;

import com.teragard.RSInterface;
import com.teragard.RSInterfaceBuilder;
import com.teragard.TextDrawingArea;

public class TextComponent {
    private final RSInterfaceBuilder builder;

    private TextComponent(int id) {
        this.builder = RSInterfaceBuilder.create(id).type(4);
    }

    public static TextComponent create(int id) {
        return new TextComponent(id);
    }

    public static TextComponent create(int id, String text) {
        return new TextComponent(id).text(text);
    }

    public TextComponent text(String message) {
        this.builder.text(message);
        return this;
    }

    public TextComponent enabledText(String message) {
        this.builder.enabledText(message);
        return this;
    }

    public TextComponent font(TextDrawingArea font) {
        this.builder.font(font);
        return this;
    }

    public TextComponent font(TextDrawingArea[] fonts, int index) {
        if (fonts != null && index >= 0 && index < fonts.length) {
            this.builder.font(fonts[index]);
        }
        return this;
    }

    public TextComponent color(int color) {
        this.builder.color(color);
        return this;
    }

    public TextComponent colors(int disabled, int enabled) {
        this.builder.colors(disabled, enabled);
        return this;
    }

    public TextComponent colors(int disabled, int enabled, int hoverDisabled, int hoverEnabled) {
        this.builder.colors(disabled, enabled, hoverDisabled, hoverEnabled);
        return this;
    }

    public TextComponent centered() {
        this.builder.centered(true);
        return this;
    }

    public TextComponent centered(boolean centered) {
        this.builder.centered(centered);
        return this;
    }

    public TextComponent shadowed() {
        this.builder.shadowed(true);
        return this;
    }

    public TextComponent shadowed(boolean shadowed) {
        this.builder.shadowed(shadowed);
        return this;
    }

    public TextComponent tooltip(String tooltip) {
        this.builder.tooltip(tooltip);
        return this;
    }

    public TextComponent clickable(String tooltip) {
        this.builder.actionType(1);
        this.builder.tooltip(tooltip);
        return this;
    }

    public TextComponent hoverType(int hoverType) {
        this.builder.hoverType(hoverType);
        return this;
    }

    public RSInterface build() {
        return this.builder.build();
    }

    public static RSInterface title(int id, String text, TextDrawingArea font) {
        return TextComponent.create(id).text(text).font(font).color(16749056).centered().shadowed().build();
    }

    public static RSInterface label(int id, String text, TextDrawingArea font) {
        return TextComponent.create(id).text(text).font(font).color(16749056).centered(false).shadowed().build();
    }

    public static RSInterface info(int id, String text, TextDrawingArea font) {
        return TextComponent.create(id).text(text).font(font).color(0xFFFF00).centered(false).shadowed().build();
    }

    public static RSInterface white(int id, String text, TextDrawingArea font) {
        return TextComponent.create(id).text(text).font(font).color(0xFFFFFF).centered().shadowed().build();
    }
}

