/*
 * Decompiled with CFR 0.152.
 */
package com.teragard.managers;

import com.teragard.RSFontSystem;
import com.teragard.Sprite;
import com.teragard.SpriteLoader;

public class OrbRenderer {
    private static OrbRenderer instance;
    private static final int[][] ORB_POSITIONS;
    private static final int COLOR_FULL = 65280;
    private static final int COLOR_HIGH = 0xFFFF00;
    private static final int COLOR_MEDIUM = 16557575;
    private static final int COLOR_LOW = 16059661;
    private static final int ORB_BG_FIXED = 0;
    private static final int ORB_BG_RESIZABLE = 11;
    private static final int ORB_BG_HOVER_FIXED = 12;
    private static final int ORB_BG_HOVER_RESIZABLE = 13;
    private static final int STANDARD_FILL_HEIGHT = 27;
    private static final int SPEC_FILL_HEIGHT = 39;
    private int hoverPos = -1;

    private OrbRenderer() {
    }

    public static OrbRenderer getInstance() {
        if (instance == null) {
            instance = new OrbRenderer();
        }
        return instance;
    }

    public int getOrbX(int orb, int clientSize, int clientWidth) {
        if (orb < 0 || orb >= ORB_POSITIONS.length) {
            return 0;
        }
        if (orb == 4) {
            return ORB_POSITIONS[orb][1];
        }
        return clientSize != 0 ? clientWidth - ORB_POSITIONS[orb][0] : ORB_POSITIONS[orb][1];
    }

    public int getOrbY(int orb, int clientSize) {
        if (orb < 0 || orb >= ORB_POSITIONS.length) {
            return 0;
        }
        return clientSize != 0 ? ORB_POSITIONS[orb][2] : ORB_POSITIONS[orb][3];
    }

    public int getPercentageColor(int percent) {
        if (percent >= 75) {
            return 65280;
        }
        if (percent >= 50) {
            return 0xFFFF00;
        }
        if (percent >= 25) {
            return 16557575;
        }
        return 16059661;
    }

    public void drawHPOrb(int clientSize, int clientWidth, int currentHP, int maxHP, boolean constitution, Sprite[] orbs, RSFontSystem font) {
        int depleteFill;
        int displayHP = currentHP / 10;
        if (!constitution) {
            displayHP /= 10;
        }
        int percent = maxHP > 0 ? (int)((double)currentHP / (double)maxHP * 100.0) : 0;
        int x = this.getOrbX(0, clientSize, clientWidth);
        int y = this.getOrbY(0, clientSize);
        orbs[clientSize == 0 ? 0 : 11].drawSprite(x, y);
        int textX = x + (clientSize == 0 ? 42 : 15);
        font.drawCenteredString(Integer.toString(displayHP), textX, y + 26, this.getPercentageColor(percent), 0);
        int fillOffset = clientSize == 0 ? 3 : 27;
        orbs[2].drawSprite(x + fillOffset, y + 3);
        double fillAmount = 27.0 * ((double)percent / 100.0);
        orbs[1].myHeight = depleteFill = 27 - (int)fillAmount;
        Sprite cfr_ignored_0 = orbs[1];
        Sprite.height = depleteFill;
        orbs[1].drawSprite(x + fillOffset, y + 3);
        int iconOffset = clientSize == 0 ? 9 : 33;
        orbs[3].drawSprite(x + iconOffset, y + 11);
    }

    public void drawPrayerOrb(int clientSize, int clientWidth, int currentPrayer, int maxPrayer, boolean quickPrsActive, Sprite[] orbs, RSFontSystem font) {
        int depleteFill;
        int displayPrayer = currentPrayer / 10;
        int maxDisplay = maxPrayer / 10;
        int percent = maxDisplay > 0 ? (int)((double)displayPrayer / (double)maxDisplay * 100.0) : 0;
        int x = this.getOrbX(1, clientSize, clientWidth);
        int y = this.getOrbY(1, clientSize);
        int bgSprite = clientSize == 0 ? (this.hoverPos == 1 ? 12 : 0) : (this.hoverPos == 1 ? 13 : 11);
        orbs[bgSprite].drawSprite(x, y);
        int textX = x + (clientSize == 0 ? 42 : 15);
        font.drawCenteredString(Integer.toString(displayPrayer), textX, y + 26, this.getPercentageColor(percent), 0);
        int fillOffset = clientSize == 0 ? 3 : 27;
        orbs[quickPrsActive ? 10 : 4].drawSprite(x + fillOffset, y + 3);
        double fillAmount = 27.0 * ((double)percent / 100.0);
        orbs[17].myHeight = depleteFill = 27 - (int)fillAmount;
        Sprite cfr_ignored_0 = orbs[17];
        Sprite.height = depleteFill;
        orbs[17].drawSprite(x + fillOffset, y + 3);
        int iconOffset = clientSize == 0 ? 7 : 31;
        orbs[5].drawSprite(x + iconOffset, y + 7);
    }

    public void drawRunOrb(int clientSize, int clientWidth, int currentEnergy, boolean running, Sprite[] orbs, RSFontSystem font) {
        int depleteFill;
        int percent = currentEnergy;
        int x = this.getOrbX(2, clientSize, clientWidth);
        int y = this.getOrbY(2, clientSize);
        int bgSprite = clientSize == 0 ? (this.hoverPos == 2 ? 12 : 0) : (this.hoverPos == 2 ? 13 : 11);
        orbs[bgSprite].drawSprite(x, y);
        int textX = x + (clientSize == 0 ? 42 : 15);
        font.drawCenteredString(Integer.toString(currentEnergy), textX, y + 26, this.getPercentageColor(percent), 0);
        int fillOffset = clientSize == 0 ? 3 : 27;
        orbs[!running ? 6 : 8].drawSprite(x + fillOffset, y + 3);
        double fillAmount = 27.0 * ((double)percent / 100.0);
        orbs[18].myHeight = depleteFill = 27 - (int)fillAmount;
        Sprite cfr_ignored_0 = orbs[18];
        Sprite.height = depleteFill;
        orbs[18].drawSprite(x + fillOffset, y + 3);
        int iconOffset = clientSize == 0 ? 10 : 34;
        orbs[!running ? 7 : 9].drawSprite(x + iconOffset, y + 7);
    }

    public void drawSummoningOrb(int clientSize, int clientWidth, int currentSummon, int maxSummon, boolean hasFamiliar, Sprite[] orbs, RSFontSystem font) {
        int depleteFill;
        int percent = maxSummon > 0 ? (int)((double)currentSummon / (double)maxSummon * 100.0) : 0;
        int x = this.getOrbX(3, clientSize, clientWidth);
        int y = this.getOrbY(3, clientSize);
        int bgSprite = clientSize == 0 ? (this.hoverPos == 3 ? 12 : 0) : (this.hoverPos == 3 ? 13 : 11);
        orbs[bgSprite].drawSprite(x, y);
        int textX = x + (clientSize == 0 ? 42 : 15);
        font.drawCenteredString(Integer.toString(currentSummon), textX, y + 26, this.getPercentageColor(percent), 0);
        int fillOffset = clientSize == 0 ? 3 : 27;
        orbs[hasFamiliar ? 16 : 14].drawSprite(x + fillOffset, y + 3);
        double fillAmount = 27.0 * ((double)percent / 100.0);
        orbs[19].myHeight = depleteFill = 27 - (int)fillAmount;
        Sprite cfr_ignored_0 = orbs[19];
        Sprite.height = depleteFill;
        orbs[19].drawSprite(x + fillOffset, y + 3);
        int iconOffset = clientSize == 0 ? 9 : 33;
        orbs[15].drawSprite(x + iconOffset, y + 9);
    }

    public void drawSpecOrb(int clientSize, int clientWidth, int currentSpec, boolean specActivated) {
        int depleteFill;
        if (clientSize > 0) {
            return;
        }
        int percent = currentSpec;
        int x = this.getOrbX(4, clientSize, clientWidth);
        int y = this.getOrbY(4, clientSize);
        if (specActivated) {
            SpriteLoader.sprites[619].drawSprite(x, y);
        } else {
            SpriteLoader.sprites[617].drawSprite(x, y);
        }
        double fillAmount = 39.0 * ((double)percent / 100.0);
        SpriteLoader.sprites[618].myHeight = depleteFill = 39 - (int)fillAmount;
        Sprite cfr_ignored_0 = SpriteLoader.sprites[618];
        Sprite.height = depleteFill;
        SpriteLoader.sprites[618].drawSprite(x, y);
        SpriteLoader.sprites[620].drawSprite(x + 7, y + 8);
    }

    public void setHoverPos(int pos) {
        this.hoverPos = pos;
    }

    public int getHoverPos() {
        return this.hoverPos;
    }

    static {
        ORB_POSITIONS = new int[][]{{212, 172, 39, 15}, {215, 188, 73, 54}, {203, 188, 107, 93}, {180, 172, 141, 128}, {0, 4, 120, 120}};
    }
}

