/*
 * Decompiled with CFR 0.152.
 */
package com.teragard.ui;

import com.teragard.DrawingArea;
import com.teragard.ItemDef;
import com.teragard.Sprite;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SpriteRenderer {
    private static final Map<String, BufferedImage> spriteCache = new ConcurrentHashMap<String, BufferedImage>();
    private static final Queue<SpriteRequest> renderQueue = new ConcurrentLinkedQueue<SpriteRequest>();
    private static volatile boolean safeRenderingEnabled = true;
    private static final Object renderLock = new Object();
    private static volatile boolean isRenderingOnGameThread = false;

    public static BufferedImage getOrQueueSprite(int itemId, int amount, int width, int height) {
        String cacheKey = itemId + "_" + amount;
        BufferedImage cached = spriteCache.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        boolean alreadyQueued = renderQueue.stream().anyMatch(r -> r.cacheKey.equals(cacheKey));
        if (!alreadyQueued) {
            renderQueue.offer(new SpriteRequest(itemId, amount, width, height));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processRenderQueue(int maxPerFrame) {
        if (renderQueue.isEmpty()) {
            return;
        }
        isRenderingOnGameThread = true;
        try {
            SpriteRequest request;
            int processed = 0;
            while (processed < maxPerFrame && (request = renderQueue.poll()) != null) {
                if (spriteCache.containsKey(request.cacheKey)) continue;
                try {
                    BufferedImage image = SpriteRenderer.renderItemSpriteSafe(request.itemId, request.amount, request.width, request.height);
                    if (image != null) {
                        spriteCache.put(request.cacheKey, image);
                    }
                    ++processed;
                }
                catch (Exception e) {
                    System.err.println("[SpriteRenderer] Error processing render request for item " + request.itemId + ": " + e.getMessage());
                }
            }
        }
        finally {
            isRenderingOnGameThread = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage renderItemSpriteSafe(int itemId, int amount, int width, int height) {
        Object object = renderLock;
        synchronized (object) {
            try {
                Sprite sprite = ItemDef.getSprite(itemId, amount, 0);
                if (sprite == null || sprite.myPixels == null) {
                    return null;
                }
                return SpriteRenderer.convertSpriteToBufferedImage(sprite, width, height);
            }
            catch (Exception e) {
                System.err.println("[SpriteRenderer] Error rendering item " + itemId + ": " + e.getMessage());
                return null;
            }
        }
    }

    public static BufferedImage renderItemSprite(int itemId, int amount, int width, int height) {
        if (safeRenderingEnabled && !isRenderingOnGameThread) {
            return SpriteRenderer.getOrQueueSprite(itemId, amount, width, height);
        }
        try {
            Sprite sprite = ItemDef.getSprite(itemId, amount, 0);
            if (sprite == null) {
                return null;
            }
            return SpriteRenderer.convertSpriteToBufferedImage(sprite, width, height);
        }
        catch (Exception e) {
            System.err.println("[SpriteRenderer] Error rendering item " + itemId + ": " + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage renderItemSpriteWithDrawingArea(int itemId, int amount, int width, int height) {
        if (safeRenderingEnabled && !isRenderingOnGameThread) {
            return SpriteRenderer.getOrQueueSprite(itemId, amount, width, height);
        }
        Object object = renderLock;
        synchronized (object) {
            try {
                Sprite sprite = ItemDef.getSprite(itemId, amount, 0);
                if (sprite == null) {
                    return null;
                }
                int[] oldPixels = DrawingArea.pixels;
                int oldWidth = DrawingArea.width;
                int oldHeight = DrawingArea.height;
                int oldTopX = DrawingArea.topX;
                int oldTopY = DrawingArea.topY;
                int oldBottomX = DrawingArea.bottomX;
                int oldBottomY = DrawingArea.bottomY;
                int[] tempPixels = new int[width * height];
                DrawingArea.pixels = tempPixels;
                DrawingArea.width = width;
                DrawingArea.height = height;
                DrawingArea.topX = 0;
                DrawingArea.topY = 0;
                DrawingArea.bottomX = width;
                DrawingArea.bottomY = height;
                for (int i = 0; i < tempPixels.length; ++i) {
                    tempPixels[i] = 0;
                }
                int x = (width - sprite.myWidth) / 2;
                int y = (height - sprite.myHeight) / 2;
                sprite.drawSprite(x, y);
                BufferedImage image = new BufferedImage(width, height, 2);
                for (int py = 0; py < height; ++py) {
                    for (int px = 0; px < width; ++px) {
                        int pixel = tempPixels[px + py * width];
                        if (pixel == 0) {
                            image.setRGB(px, py, 0);
                            continue;
                        }
                        if ((pixel & 0xFF000000) == 0) {
                            pixel |= 0xFF000000;
                        }
                        image.setRGB(px, py, pixel);
                    }
                }
                DrawingArea.pixels = oldPixels;
                DrawingArea.width = oldWidth;
                DrawingArea.height = oldHeight;
                DrawingArea.topX = oldTopX;
                DrawingArea.topY = oldTopY;
                DrawingArea.bottomX = oldBottomX;
                DrawingArea.bottomY = oldBottomY;
                return image;
            }
            catch (Exception e) {
                System.err.println("[SpriteRenderer] Error in renderItemSpriteWithDrawingArea for item " + itemId + ": " + e.getMessage());
                return null;
            }
        }
    }

    public static BufferedImage convertSpriteToBufferedImage(Sprite sprite, int targetWidth, int targetHeight) {
        if (sprite == null || sprite.myPixels == null) {
            return null;
        }
        BufferedImage image = new BufferedImage(targetWidth, targetHeight, 2);
        int offsetX = (targetWidth - sprite.myWidth) / 2;
        int offsetY = (targetHeight - sprite.myHeight) / 2;
        for (int y = 0; y < sprite.myHeight; ++y) {
            for (int x = 0; x < sprite.myWidth; ++x) {
                int pixelIndex;
                int targetX = x + offsetX;
                int targetY = y + offsetY;
                if (targetX < 0 || targetX >= targetWidth || targetY < 0 || targetY >= targetHeight || (pixelIndex = x + y * sprite.myWidth) >= sprite.myPixels.length) continue;
                int pixel = sprite.myPixels[pixelIndex];
                if (pixel == 0) {
                    image.setRGB(targetX, targetY, 0);
                    continue;
                }
                if ((pixel & 0xFF000000) == 0) {
                    pixel |= 0xFF000000;
                }
                image.setRGB(targetX, targetY, pixel);
            }
        }
        return image;
    }

    public static void clearCache() {
        spriteCache.clear();
        renderQueue.clear();
    }

    public static int getCacheSize() {
        return spriteCache.size();
    }

    public static int getPendingRenderCount() {
        return renderQueue.size();
    }

    public static void setSafeRenderingEnabled(boolean enabled) {
        safeRenderingEnabled = enabled;
    }

    public static boolean isCached(int itemId, int amount) {
        return spriteCache.containsKey(itemId + "_" + amount);
    }

    public static void preRenderSprites(int[] itemIds, int width, int height) {
        for (int itemId : itemIds) {
            if (itemId <= 0 || SpriteRenderer.isCached(itemId, 1)) continue;
            renderQueue.offer(new SpriteRequest(itemId, 1, width, height));
        }
    }

    private static class SpriteRequest {
        final int itemId;
        final int amount;
        final int width;
        final int height;
        final String cacheKey;

        SpriteRequest(int itemId, int amount, int width, int height) {
            this.itemId = itemId;
            this.amount = amount;
            this.width = width;
            this.height = height;
            this.cacheKey = itemId + "_" + amount;
        }
    }
}

