/*
 * Decompiled with CFR 0.152.
 */
package com.teragard.ui;

import com.teragard.Sprite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class UIAssets {
    private static BufferedImage loginBackground;
    private static BufferedImage loginBackgroundWithLogo;
    private static BufferedImage loginBox;
    private static BufferedImage clientLogo;
    private static BufferedImage loginButtonNormal;
    private static BufferedImage loginButtonHover;
    private static BufferedImage discordButtonNormal;
    private static BufferedImage discordButtonHover;
    private static BufferedImage usernameIconNormal;
    private static BufferedImage usernameIconHover;
    private static BufferedImage passwordIconNormal;
    private static BufferedImage passwordIconHover;
    private static BufferedImage saveIconNormal;
    private static BufferedImage saveIconHover;
    private static BufferedImage messageBar;
    private static BufferedImage loadingBackground;
    private static BufferedImage loadingBackgroundWithLogo;
    private static BufferedImage loadingInsideContainer;
    private static BufferedImage loadingOutsideContainer;
    private static Sprite spriteLoginBackground;
    private static Sprite spriteLoginBackgroundWithLogo;
    private static Sprite spriteLoginBox;
    private static Sprite spriteClientLogo;
    private static Sprite spriteLoginButtonNormal;
    private static Sprite spriteLoginButtonHover;
    private static Sprite spriteDiscordNormal;
    private static Sprite spriteDiscordHover;
    private static Sprite spriteUsernameNormal;
    private static Sprite spriteUsernameHover;
    private static Sprite spritePasswordNormal;
    private static Sprite spritePasswordHover;
    private static Sprite spriteSaveNormal;
    private static Sprite spriteSaveHover;
    private static Sprite spriteMessageBar;
    private static Sprite spriteLoadingBackground;
    private static Sprite spriteLoadingBackgroundWithLogo;
    private static Sprite spriteLoadingInside;
    private static Sprite spriteLoadingOutside;
    private static boolean initialized;

    public static void init() {
        if (initialized) {
            return;
        }
        System.out.println("Loading UI assets...");
        loginBackground = UIAssets.loadImage("loading_background.png");
        loginBackgroundWithLogo = UIAssets.loadImage("login_with_logo_and_box.png");
        loginBox = UIAssets.loadImage("login_box.png");
        clientLogo = UIAssets.loadImage("client_logo.png");
        loginButtonNormal = UIAssets.loadImage("login_normal.png");
        loginButtonHover = UIAssets.loadImage("login_hover.png");
        discordButtonNormal = UIAssets.loadImage("discord_normal.png");
        discordButtonHover = UIAssets.loadImage("discord_hover.png");
        usernameIconNormal = UIAssets.loadImage("username_normal.png");
        usernameIconHover = UIAssets.loadImage("username_hover.png");
        passwordIconNormal = UIAssets.loadImage("password_normal.png");
        passwordIconHover = UIAssets.loadImage("password_hover.png");
        saveIconNormal = UIAssets.loadImage("save_normal.png");
        saveIconHover = UIAssets.loadImage("save_hover.png");
        messageBar = UIAssets.loadImage("message_bar.png");
        loadingBackground = UIAssets.loadImage("loading_background.png");
        loadingBackgroundWithLogo = UIAssets.loadImage("loading_background_with_logo.png");
        loadingInsideContainer = UIAssets.loadImage("loading_inside_container.png");
        loadingOutsideContainer = UIAssets.loadImage("loading_outside.png");
        UIAssets.createSprites();
        initialized = true;
        System.out.println("UI assets loaded successfully.");
    }

    private static void createSprites() {
        try {
            if (loginBackground != null) {
                spriteLoginBackground = new Sprite(loginBackground);
            }
            if (loginBackgroundWithLogo != null) {
                spriteLoginBackgroundWithLogo = new Sprite(loginBackgroundWithLogo);
            }
            if (loginBox != null) {
                spriteLoginBox = new Sprite(loginBox);
            }
            if (clientLogo != null) {
                spriteClientLogo = new Sprite(clientLogo);
            }
            if (loginButtonNormal != null) {
                spriteLoginButtonNormal = new Sprite(loginButtonNormal);
            }
            if (loginButtonHover != null) {
                spriteLoginButtonHover = new Sprite(loginButtonHover);
            }
            if (discordButtonNormal != null) {
                spriteDiscordNormal = new Sprite(discordButtonNormal);
            }
            if (discordButtonHover != null) {
                spriteDiscordHover = new Sprite(discordButtonHover);
            }
            if (usernameIconNormal != null) {
                spriteUsernameNormal = new Sprite(usernameIconNormal);
            }
            if (usernameIconHover != null) {
                spriteUsernameHover = new Sprite(usernameIconHover);
            }
            if (passwordIconNormal != null) {
                spritePasswordNormal = new Sprite(passwordIconNormal);
            }
            if (passwordIconHover != null) {
                spritePasswordHover = new Sprite(passwordIconHover);
            }
            if (saveIconNormal != null) {
                spriteSaveNormal = new Sprite(saveIconNormal);
            }
            if (saveIconHover != null) {
                spriteSaveHover = new Sprite(saveIconHover);
            }
            if (messageBar != null) {
                spriteMessageBar = new Sprite(messageBar);
            }
            if (loadingBackground != null) {
                spriteLoadingBackground = new Sprite(loadingBackground);
            }
            if (loadingBackgroundWithLogo != null) {
                spriteLoadingBackgroundWithLogo = new Sprite(loadingBackgroundWithLogo);
            }
            if (loadingInsideContainer != null) {
                spriteLoadingInside = new Sprite(loadingInsideContainer);
            }
            if (loadingOutsideContainer != null) {
                spriteLoadingOutside = new Sprite(loadingOutsideContainer);
            }
        }
        catch (Exception e) {
            System.err.println("Error creating sprites: " + e.getMessage());
        }
    }

    public static Sprite createScaledSprite(BufferedImage img, int width, int height) {
        if (img == null) {
            return null;
        }
        BufferedImage scaled = new BufferedImage(width, height, 2);
        Graphics2D g = scaled.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(img, 0, 0, width, height, null);
        g.dispose();
        return new Sprite(scaled);
    }

    private static BufferedImage loadImage(String name) {
        try {
            InputStream is = UIAssets.class.getResourceAsStream("/ui/" + name);
            if (is != null) {
                BufferedImage img = ImageIO.read(is);
                is.close();
                return img;
            }
            System.err.println("Could not find UI asset: " + name);
        }
        catch (IOException e) {
            System.err.println("Failed to load UI asset: " + name + " - " + e.getMessage());
        }
        return null;
    }

    public static void drawCover(Graphics2D g, BufferedImage img, int x, int y, int width, int height) {
        int drawY;
        int drawX;
        int drawWidth;
        int drawHeight;
        double targetRatio;
        if (img == null) {
            return;
        }
        double imgRatio = (double)img.getWidth() / (double)img.getHeight();
        if (imgRatio > (targetRatio = (double)width / (double)height)) {
            drawHeight = height;
            drawWidth = (int)((double)height * imgRatio);
            drawX = x - (drawWidth - width) / 2;
            drawY = y;
        } else {
            drawWidth = width;
            drawHeight = (int)((double)width / imgRatio);
            drawX = x;
            drawY = y - (drawHeight - height) / 2;
        }
        g.drawImage(img, drawX, drawY, drawWidth, drawHeight, null);
    }

    public static void drawCentered(Graphics2D g, BufferedImage img, int centerX, int centerY) {
        if (img == null) {
            return;
        }
        g.drawImage((Image)img, centerX - img.getWidth() / 2, centerY - img.getHeight() / 2, null);
    }

    public static void drawCentered(Graphics2D g, BufferedImage img, int centerX, int centerY, int width, int height) {
        if (img == null) {
            return;
        }
        g.drawImage(img, centerX - width / 2, centerY - height / 2, width, height, null);
    }

    public static BufferedImage getLoginBackground() {
        return loginBackground;
    }

    public static BufferedImage getLoginBackgroundWithLogo() {
        return loginBackgroundWithLogo;
    }

    public static BufferedImage getLoginBox() {
        return loginBox;
    }

    public static BufferedImage getClientLogo() {
        return clientLogo;
    }

    public static BufferedImage getLoginButtonNormal() {
        return loginButtonNormal;
    }

    public static BufferedImage getLoginButtonHover() {
        return loginButtonHover;
    }

    public static BufferedImage getDiscordButtonNormal() {
        return discordButtonNormal;
    }

    public static BufferedImage getDiscordButtonHover() {
        return discordButtonHover;
    }

    public static BufferedImage getUsernameIconNormal() {
        return usernameIconNormal;
    }

    public static BufferedImage getUsernameIconHover() {
        return usernameIconHover;
    }

    public static BufferedImage getPasswordIconNormal() {
        return passwordIconNormal;
    }

    public static BufferedImage getPasswordIconHover() {
        return passwordIconHover;
    }

    public static BufferedImage getSaveIconNormal() {
        return saveIconNormal;
    }

    public static BufferedImage getSaveIconHover() {
        return saveIconHover;
    }

    public static BufferedImage getMessageBar() {
        return messageBar;
    }

    public static BufferedImage getLoadingBackground() {
        return loadingBackground;
    }

    public static BufferedImage getLoadingBackgroundWithLogo() {
        return loadingBackgroundWithLogo;
    }

    public static BufferedImage getLoadingInsideContainer() {
        return loadingInsideContainer;
    }

    public static BufferedImage getLoadingOutsideContainer() {
        return loadingOutsideContainer;
    }

    public static Sprite getSpriteLoginBackground() {
        return spriteLoginBackground;
    }

    public static Sprite getSpriteLoginBackgroundWithLogo() {
        return spriteLoginBackgroundWithLogo;
    }

    public static Sprite getSpriteLoginBox() {
        return spriteLoginBox;
    }

    public static Sprite getSpriteClientLogo() {
        return spriteClientLogo;
    }

    public static Sprite getSpriteLoginButtonNormal() {
        return spriteLoginButtonNormal;
    }

    public static Sprite getSpriteLoginButtonHover() {
        return spriteLoginButtonHover;
    }

    public static Sprite getSpriteDiscordNormal() {
        return spriteDiscordNormal;
    }

    public static Sprite getSpriteDiscordHover() {
        return spriteDiscordHover;
    }

    public static Sprite getSpriteUsernameNormal() {
        return spriteUsernameNormal;
    }

    public static Sprite getSpriteUsernameHover() {
        return spriteUsernameHover;
    }

    public static Sprite getSpritePasswordNormal() {
        return spritePasswordNormal;
    }

    public static Sprite getSpritePasswordHover() {
        return spritePasswordHover;
    }

    public static Sprite getSpriteSaveNormal() {
        return spriteSaveNormal;
    }

    public static Sprite getSpriteSaveHover() {
        return spriteSaveHover;
    }

    public static Sprite getSpriteMessageBar() {
        return spriteMessageBar;
    }

    public static Sprite getSpriteLoadingBackground() {
        return spriteLoadingBackground;
    }

    public static Sprite getSpriteLoadingBackgroundWithLogo() {
        return spriteLoadingBackgroundWithLogo;
    }

    public static Sprite getSpriteLoadingInside() {
        return spriteLoadingInside;
    }

    public static Sprite getSpriteLoadingOutside() {
        return spriteLoadingOutside;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    static {
        initialized = false;
    }
}

