/*
 * Decompiled with CFR 0.152.
 */
package com.teragard.ui.sidebar;

import com.teragard.ui.sidebar.SidebarTab;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;

public class PresetsTab
implements SidebarTab {
    private static final Color BG_PRIMARY = new Color(30, 30, 40);
    private static final Color BG_SECONDARY = new Color(40, 40, 50);
    private static final Color BG_PRESET = new Color(45, 45, 60);
    private static final Color BG_PRESET_HOVER = new Color(50, 50, 70);
    private static final Color TEXT_PRIMARY = new Color(240, 240, 250);
    private static final Color TEXT_SECONDARY = new Color(160, 160, 180);
    private static final Color ACCENT = new Color(120, 120, 255);
    private static final Color SUCCESS = new Color(100, 200, 100);
    private static final Color WARNING = new Color(255, 200, 100);
    private static final Color DANGER = new Color(255, 100, 100);
    private List<GearPreset> presets = new ArrayList<GearPreset>();
    private GearPreset selectedPreset = null;
    private int scrollOffset = 0;
    private int mouseX = 0;
    private int mouseY = 0;
    private static final int PRESET_ITEM_HEIGHT = 60;
    private static final int PRESET_PADDING = 10;
    private static final int BUTTON_HEIGHT = 35;

    public PresetsTab() {
        this.loadPresets();
    }

    @Override
    public String getName() {
        return "Presets";
    }

    @Override
    public String getDescription() {
        return "Save and load gear setups";
    }

    @Override
    public void render(Graphics2D g, int x, int y, int width, int height) {
        g.setColor(BG_PRIMARY);
        g.fillRect(x, y, width, height);
        g.setFont(new Font("Arial", 1, 16));
        g.setColor(TEXT_PRIMARY);
        g.drawString("Gear Presets", x + 15, y + 25);
        g.setFont(new Font("Arial", 0, 12));
        g.setColor(TEXT_SECONDARY);
        g.drawString(this.presets.size() + " saved", x + 15, y + 45);
        int buttonY = y + 60;
        this.drawButton(g, x + 15, buttonY, width - 30, 35, "+ Save Current Setup", SUCCESS, this.isMouseOverButton(x + 15, buttonY, width - 30, 35));
        int listY = buttonY + 35 + 20;
        int listHeight = height - (listY - y) - 60;
        this.drawPresetList(g, x + 15, listY, width - 30, listHeight);
        if (this.selectedPreset != null) {
            int bottomY = y + height - 50;
            this.drawButton(g, x + 15, bottomY, (width - 45) / 2, 35, "Load", ACCENT, this.isMouseOverButton(x + 15, bottomY, (width - 45) / 2, 35));
            int deleteX = x + 15 + (width - 45) / 2 + 15;
            this.drawButton(g, deleteX, bottomY, (width - 45) / 2, 35, "Delete", DANGER, this.isMouseOverButton(deleteX, bottomY, (width - 45) / 2, 35));
        }
    }

    private void drawPresetList(Graphics2D g, int x, int y, int width, int height) {
        g.setColor(BG_SECONDARY);
        g.fillRoundRect(x, y, width, height, 10, 10);
        g.setColor(new Color(60, 60, 75));
        g.setStroke(new BasicStroke(1.0f));
        g.drawRoundRect(x, y, width, height, 10, 10);
        if (this.presets.isEmpty()) {
            g.setFont(new Font("Arial", 2, 14));
            g.setColor(TEXT_SECONDARY);
            String msg = "No presets saved";
            FontMetrics fm = g.getFontMetrics();
            int msgWidth = fm.stringWidth(msg);
            g.drawString(msg, x + (width - msgWidth) / 2, y + height / 2);
            String hint = "Click '+ Save Current Setup' to create one";
            g.setFont(new Font("Arial", 0, 12));
            int hintWidth = g.getFontMetrics().stringWidth(hint);
            g.drawString(hint, x + (width - hintWidth) / 2, y + height / 2 + 20);
            return;
        }
        Shape oldClip = g.getClip();
        g.setClip(x + 5, y + 5, width - 10, height - 10);
        int itemY = y + 10 - this.scrollOffset;
        for (GearPreset preset : this.presets) {
            boolean isSelected = preset == this.selectedPreset;
            boolean isHovering = this.isMouseOverPreset(x + 10, itemY, width - 20, 60);
            if (isSelected) {
                g.setColor(ACCENT);
            } else if (isHovering) {
                g.setColor(BG_PRESET_HOVER);
            } else {
                g.setColor(BG_PRESET);
            }
            g.fillRoundRect(x + 10, itemY, width - 20, 60, 8, 8);
            g.setFont(new Font("Arial", 1, 14));
            g.setColor(isSelected ? Color.WHITE : TEXT_PRIMARY);
            g.drawString(preset.getName(), x + 20, itemY + 25);
            g.setFont(new Font("Arial", 0, 11));
            g.setColor(TEXT_SECONDARY);
            g.drawString(preset.getItemCount() + " items", x + 20, itemY + 42);
            itemY += 70;
        }
        g.setClip(oldClip);
    }

    private void drawButton(Graphics2D g, int x, int y, int width, int height, String text, Color baseColor, boolean isHovering) {
        Color buttonColor = isHovering ? this.brighten(baseColor, 1.2f) : baseColor;
        g.setColor(buttonColor);
        g.fillRoundRect(x, y, width, height, 8, 8);
        g.setFont(new Font("Arial", 1, 13));
        g.setColor(Color.WHITE);
        FontMetrics fm = g.getFontMetrics();
        int textWidth = fm.stringWidth(text);
        int textX = x + (width - textWidth) / 2;
        int textY = y + (height + fm.getAscent()) / 2 - 2;
        g.drawString(text, textX, textY);
    }

    private Color brighten(Color color, float factor) {
        int r = Math.min(255, (int)((float)color.getRed() * factor));
        int g = Math.min(255, (int)((float)color.getGreen() * factor));
        int b = Math.min(255, (int)((float)color.getBlue() * factor));
        return new Color(r, g, b);
    }

    @Override
    public void handleClick(int x, int y) {
        int buttonY = 60;
        if (this.isMouseOverButton(15, buttonY, 0, 35)) {
            this.createNewPreset();
            return;
        }
        int listY = buttonY + 35 + 20;
        int itemY = listY + 10 - this.scrollOffset;
        for (GearPreset preset : this.presets) {
            if (this.isMouseOverPreset(25, itemY, 0, 60)) {
                this.selectedPreset = preset;
                System.out.println("[PresetsTab] Selected preset: " + preset.getName());
                return;
            }
            itemY += 70;
        }
        if (this.selectedPreset != null && this.isMouseOverButton(15, 0, 0, 35)) {
            this.loadPreset(this.selectedPreset);
            return;
        }
    }

    @Override
    public void handleMouseMove(int x, int y) {
        this.mouseX = x;
        this.mouseY = y;
    }

    private boolean isMouseOverButton(int x, int y, int width, int height) {
        return this.mouseX >= x && this.mouseX < x + width && this.mouseY >= y && this.mouseY < y + height;
    }

    private boolean isMouseOverPreset(int x, int y, int width, int height) {
        return this.mouseX >= x && this.mouseX < x + width && this.mouseY >= y && this.mouseY < y + height;
    }

    private void loadPresets() {
        this.presets.add(new GearPreset("PvM - Bandos", 1));
        this.presets.add(new GearPreset("PvP - Melee", 2));
        this.presets.add(new GearPreset("Skilling - Mining", 3));
    }

    private void createNewPreset() {
        System.out.println("[PresetsTab] Creating new preset...");
        String name = "Preset " + (this.presets.size() + 1);
        GearPreset newPreset = new GearPreset(name, this.presets.size() + 1);
        this.presets.add(newPreset);
        this.selectedPreset = newPreset;
    }

    private void loadPreset(GearPreset preset) {
        System.out.println("[PresetsTab] Loading preset: " + preset.getName());
    }

    public static class GearPreset {
        private String name;
        private int id;
        private int itemCount;

        public GearPreset(String name, int id) {
            this.name = name;
            this.id = id;
            this.itemCount = 15;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public int getItemCount() {
            return this.itemCount;
        }
    }
}

